/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SnomedMetadata {
    public static final SnomedMetadata INSTANCE = new SnomedMetadata();
    protected Properties props = new Properties();
    protected Set<String> neverGroupedIds = new HashSet<String>();
    protected Map<String, String> rightIdentities = new HashMap<String, String>();

    private SnomedMetadata() {
        try {
            this.props.load(this.getClass().getResourceAsStream("/metadata.txt"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getConceptModelAttId() {
        return this.props.getProperty("conceptModelAttId");
    }

    public String getIsAId() {
        return this.props.getProperty("isAId");
    }

    public String getLateralityId() {
        return this.props.getProperty("lateralityId");
    }

    public String getConceptDefinedId() {
        return this.props.getProperty("conceptDefinedId");
    }

    public String getSomeId() {
        return this.props.getProperty("someId");
    }

    public String getFsnId() {
        return this.props.getProperty("fsnId");
    }

    public String getSynonymId() {
        return this.props.getProperty("synonymId");
    }

    public String getDefinitionId() {
        return this.props.getProperty("definitionId");
    }

    public String getNeverGroupedIdsString() {
        return this.props.getProperty("neverGroupedIds");
    }

    public Set<String> getNeverGroupedIds() {
        String[] parts;
        String s = this.props.getProperty("neverGroupedIds");
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> res = new HashSet<String>();
        for (String part : parts = s.split("[,]")) {
            res.add(part);
        }
        return res;
    }

    public String getRightIdentityIdsString() {
        return this.props.getProperty("rightIdentityIds");
    }

    public Map<String, String> getRightIdentityIds() {
        String s = this.props.getProperty("rightIdentityIds");
        if (s == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        String[] parts = s.split("[,]");
        res.put(parts[0], parts[1]);
        return res;
    }

    public String getRoleGroupId() {
        return this.props.getProperty("roleGroupId");
    }
}

