/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.snomed.refset.rf2;

import au.csiro.ontology.input.MapView;
import au.csiro.ontology.input.StructuredLog;
import au.csiro.ontology.snomed.refset.rf2.ModuleDependencyRefset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDependencyRow
implements MapView {
    private static final Logger log = LoggerFactory.getLogger(ModuleDependencyRow.class);
    protected final String id;
    protected final String effectiveTime;
    protected final boolean active;
    protected final String moduleId;
    protected final String refsetId;
    protected final String referencedComponentId;
    protected final String sourceEffectiveTime;
    protected final String targetEffectiveTime;
    private boolean malformed = false;

    public ModuleDependencyRow(String id, String effectiveTime, boolean active, String moduleId, String refsetId, String referencedComponentId, String sourceEffectiveTime, String targetEffectiveTime) {
        this.id = id;
        this.effectiveTime = effectiveTime;
        this.active = active;
        this.moduleId = moduleId;
        this.refsetId = refsetId;
        this.referencedComponentId = referencedComponentId;
        this.sourceEffectiveTime = sourceEffectiveTime;
        this.targetEffectiveTime = targetEffectiveTime;
        if (active) {
            if (!refsetId.equals("900000000000534007")) {
                this.malformed = true;
                StructuredLog.RefsetIdMismatch.error(this.toMap(), log, new Object[0]);
            }
            if (!effectiveTime.equals(sourceEffectiveTime)) {
                this.malformed = true;
                StructuredLog.TimesMismatch.error(this.toMap(), log, new Object[0]);
            }
            if (ModuleDependencyRefset.parseTime(effectiveTime).compareTo(ModuleDependencyRefset.parseTime(sourceEffectiveTime)) < 0) {
                this.malformed = true;
                StructuredLog.EffectgiveTimeOrderMismatch.error(this.toMap(), log, new Object[0]);
            }
            if (ModuleDependencyRefset.parseTime(sourceEffectiveTime).compareTo(ModuleDependencyRefset.parseTime(targetEffectiveTime)) < 0) {
                this.malformed = true;
                StructuredLog.SourceTimeMismatch.error(this.toMap(), log, new Object[0]);
            }
        }
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "ModuleDependencyRow");
        map.put("id", this.id);
        map.put("effectiveTime", this.effectiveTime);
        map.put("active", this.active);
        map.put("moduleId", this.moduleId);
        map.put("refsetId", this.refsetId);
        map.put("referencedComponentId", this.referencedComponentId);
        map.put("sourceEffectiveTime", this.sourceEffectiveTime);
        map.put("targetEffectiveTime", this.targetEffectiveTime);
        return map;
    }

    boolean isMalformed() {
        return this.malformed;
    }

    public String getId() {
        return this.id;
    }

    public String getEffectiveTime() {
        return this.effectiveTime;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getRefsetId() {
        return this.refsetId;
    }

    public String getReferencedComponentId() {
        return this.referencedComponentId;
    }

    public String getSourceEffectiveTime() {
        return this.sourceEffectiveTime;
    }

    public String getTargetEffectiveTime() {
        return this.targetEffectiveTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.effectiveTime == null ? 0 : this.effectiveTime.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.moduleId == null ? 0 : this.moduleId.hashCode());
        result = 31 * result + (this.referencedComponentId == null ? 0 : this.referencedComponentId.hashCode());
        result = 31 * result + (this.refsetId == null ? 0 : this.refsetId.hashCode());
        result = 31 * result + (this.sourceEffectiveTime == null ? 0 : this.sourceEffectiveTime.hashCode());
        result = 31 * result + (this.targetEffectiveTime == null ? 0 : this.targetEffectiveTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDependencyRow other = (ModuleDependencyRow)obj;
        if (this.active != other.active) {
            return false;
        }
        if (this.effectiveTime == null ? other.effectiveTime != null : !this.effectiveTime.equals(other.effectiveTime)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.moduleId == null ? other.moduleId != null : !this.moduleId.equals(other.moduleId)) {
            return false;
        }
        if (this.referencedComponentId == null ? other.referencedComponentId != null : !this.referencedComponentId.equals(other.referencedComponentId)) {
            return false;
        }
        if (this.refsetId == null ? other.refsetId != null : !this.refsetId.equals(other.refsetId)) {
            return false;
        }
        if (this.sourceEffectiveTime == null ? other.sourceEffectiveTime != null : !this.sourceEffectiveTime.equals(other.sourceEffectiveTime)) {
            return false;
        }
        return !(this.targetEffectiveTime == null ? other.targetEffectiveTime != null : !this.targetEffectiveTime.equals(other.targetEffectiveTime));
    }

    public String toString() {
        return StructuredLog.renderMap(this.toMap());
    }
}

