/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;

public abstract class Input {
    protected InputType inputType;
    protected String base;
    protected ZipFile zip = null;

    public InputType getInputType() {
        return this.inputType;
    }

    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    /*
     * Enabled aggressive block sorting
     */
    public InputStream getInputStream(String name) throws IOException {
        File file;
        InputType type = this.getInputType();
        if (!type.equals((Object)InputType.EXTERNAL)) {
            if (!type.equals((Object)InputType.CLASSPATH)) throw new RuntimeException("Unexpected input type " + (Object)((Object)type));
            InputStream stream = this.getClass().getResourceAsStream(name);
            if (null != stream) return stream;
            throw new FileNotFoundException(name + " not found in classpath");
        }
        if (this.base == null) {
            file = new File(name);
            return new FileInputStream(file);
        }
        File baseFile = new File(this.base);
        if (!baseFile.isDirectory()) {
            this.zip = new ZipFile(this.base);
            return this.zip.getInputStream(this.zip.getEntry(name));
        }
        File child = new File(name);
        if (child.isAbsolute()) {
            file = child;
            return new FileInputStream(file);
        }
        file = new File(baseFile, name);
        return new FileInputStream(file);
    }

    public void close() throws IOException {
        if (null != this.zip) {
            this.zip.close();
            this.zip = null;
        }
    }

    public void validate() {
        switch (this.getInputType()) {
            case CLASSPATH: {
                if (null == this.getBase()) break;
                throw new RuntimeException("Base must not be specified with " + (Object)((Object)this.getInputType()));
            }
            case EXTERNAL: {
                if (null != this.getBase()) break;
                throw new RuntimeException("Base must be specified with " + (Object)((Object)this.getInputType()));
            }
            default: {
                throw new RuntimeException("Invalid inputType: " + (Object)((Object)this.getInputType()));
            }
        }
    }

    public static enum InputType {
        EXTERNAL,
        CLASSPATH;

    }
}

