/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.model;

import au.csiro.ontology.model.Literal;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class FloatLiteral
extends Literal {
    private static final long serialVersionUID = 1L;
    private float value;

    public FloatLiteral() {
    }

    public FloatLiteral(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.value);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatLiteral other = (FloatLiteral)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(Literal o) {
        FloatLiteral fl = (FloatLiteral)o;
        float otherValue = fl.value;
        return Float.compare(this.value, otherValue);
    }
}

