/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.model;

import au.csiro.ontology.model.Concept;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Conjunction
extends Concept {
    private static final long serialVersionUID = 1L;
    private Concept[] concepts;
    private int hashCode;

    public Conjunction() {
        this(Collections.EMPTY_SET);
    }

    public Conjunction(Concept[] concepts) {
        this.setConcepts(concepts);
    }

    public Conjunction(Collection<? extends Concept> concepts) {
        TreeSet<? extends Concept> sorted = new TreeSet<Concept>(concepts);
        this.concepts = sorted.toArray(new Concept[sorted.size()]);
        this.hashCode = ((Object)sorted).hashCode();
    }

    public Concept[] getConcepts() {
        return this.concepts;
    }

    public void setConcepts(Concept[] concepts) {
        TreeSet<Concept> sorted = new TreeSet<Concept>();
        for (Concept concept : concepts) {
            sorted.add(concept);
        }
        this.concepts = sorted.toArray(new Concept[sorted.size()]);
        this.hashCode = ((Object)sorted).hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (this.concepts.length > 0) {
            sb.append(this.concepts[0]);
            for (int i = 1; i < this.concepts.length; ++i) {
                sb.append(" + ");
                sb.append(this.concepts[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conjunction other = (Conjunction)obj;
        return this.hashCode == other.hashCode && Arrays.equals(this.concepts, other.concepts);
    }

    @Override
    public int compareTo(Concept o) {
        Class<?> otherClass;
        Class<?> thisClass = this.getClass();
        if (thisClass.equals(otherClass = o.getClass())) {
            Conjunction other = (Conjunction)o;
            int res = 0;
            res = this.concepts.length - other.concepts.length;
            if (res != 0) {
                return res;
            }
            for (int i = 0; i < this.concepts.length; ++i) {
                try {
                    res = this.concepts[i].compareTo(other.concepts[i]);
                }
                catch (ClassCastException e) {
                    res = this.concepts[i].getClass().toString().compareTo(other.concepts[i].getClass().toString());
                }
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
        return thisClass.toString().compareTo(otherClass.toString());
    }
}

