/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.importer.owl;

import au.csiro.ontology.Ontology;
import au.csiro.ontology.importer.BaseImporter;
import au.csiro.ontology.importer.ImportException;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.BigIntegerLiteral;
import au.csiro.ontology.model.Concept;
import au.csiro.ontology.model.ConceptInclusion;
import au.csiro.ontology.model.Conjunction;
import au.csiro.ontology.model.Datatype;
import au.csiro.ontology.model.DateLiteral;
import au.csiro.ontology.model.DecimalLiteral;
import au.csiro.ontology.model.Existential;
import au.csiro.ontology.model.Feature;
import au.csiro.ontology.model.FloatLiteral;
import au.csiro.ontology.model.IntegerLiteral;
import au.csiro.ontology.model.Literal;
import au.csiro.ontology.model.NamedConcept;
import au.csiro.ontology.model.NamedFeature;
import au.csiro.ontology.model.NamedRole;
import au.csiro.ontology.model.Operator;
import au.csiro.ontology.model.Role;
import au.csiro.ontology.model.RoleInclusion;
import au.csiro.ontology.model.StringLiteral;
import au.csiro.ontology.util.IProgressMonitor;
import au.csiro.ontology.util.Statistics;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.bind.DatatypeConverter;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class OWLImporter
extends BaseImporter {
    public static final String THING_IRI = "http://www.w3.org/2002/07/owl#Thing";
    public static final String NOTHING_IRI = "http://www.w3.org/2002/07/owl#Nothing";
    private final Set<OWLDataPropertyRangeAxiom> dprAxioms = new HashSet<OWLDataPropertyRangeAxiom>();
    private final List<String> problems = new ArrayList<String>();
    private OWLOntology ontology;
    private List<OWLAxiom> axioms;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private boolean useSimpleInts = true;
    private boolean useSimpleFloats = true;

    public OWLImporter(OWLOntology ontology) {
        this();
        this.ontology = ontology;
    }

    public OWLImporter(List<OWLAxiom> axioms) {
        this();
        this.axioms = axioms;
    }

    private OWLImporter() {
    }

    public boolean isUseSimpleInts() {
        return this.useSimpleInts;
    }

    public void setUseSimpleInts(boolean useSimpleInts) {
        this.useSimpleInts = useSimpleInts;
    }

    public boolean isUseSimpleFloats() {
        return this.useSimpleFloats;
    }

    public void setUseSimpleFloats(boolean useSimpleFloats) {
        this.useSimpleFloats = useSimpleFloats;
    }

    private Axiom transformOWLSubPropertyChainOfAxiom(OWLSubPropertyChainOfAxiom a) {
        List sub = a.getPropertyChain();
        OWLObjectPropertyExpression sup = a.getSuperProperty();
        int size = sub.size();
        Role[] lhss = new Role[size];
        for (int i = 0; i < size; ++i) {
            lhss[i] = new NamedRole(((OWLObjectPropertyExpression)sub.get(i)).asOWLObjectProperty().toStringID());
        }
        NamedRole rhs = new NamedRole(sup.asOWLObjectProperty().toStringID());
        if (lhss.length == 1 || lhss.length == 2) {
            return new RoleInclusion(lhss, (Role)rhs);
        }
        this.problems.add("Unable to import axiom " + a.toString() + ". RoleChains longer than 2 not supported.");
        return null;
    }

    private Axiom transformOWLSubObjectPropertyOfAxiom(OWLSubObjectPropertyOfAxiom a) {
        OWLObjectPropertyExpression sub = (OWLObjectPropertyExpression)a.getSubProperty();
        OWLObjectPropertyExpression sup = (OWLObjectPropertyExpression)a.getSuperProperty();
        NamedRole lhs = new NamedRole(sub.asOWLObjectProperty().toStringID());
        NamedRole rhs = new NamedRole(sup.asOWLObjectProperty().toStringID());
        return new RoleInclusion(new Role[]{lhs}, (Role)rhs);
    }

    private Axiom transformOWLReflexiveObjectPropertyAxiom(OWLReflexiveObjectPropertyAxiom a) {
        OWLObjectPropertyExpression exp = (OWLObjectPropertyExpression)a.getProperty();
        return new RoleInclusion(new Role[0], (Role)new NamedRole(exp.asOWLObjectProperty().toStringID()));
    }

    private Axiom transformOWLTransitiveObjectPropertyAxiom(OWLTransitiveObjectPropertyAxiom a) {
        OWLObjectPropertyExpression exp = (OWLObjectPropertyExpression)a.getProperty();
        NamedRole r = new NamedRole(exp.asOWLObjectProperty().toStringID());
        return new RoleInclusion(new Role[]{r, r}, (Role)r);
    }

    private Axiom transformOWLSubClassOfAxiom(OWLSubClassOfAxiom a) {
        OWLClassExpression sub = a.getSubClass();
        OWLClassExpression sup = a.getSuperClass();
        try {
            Concept subConcept = this.getConcept(sub);
            Concept superConcept = this.getConcept(sup);
            return new ConceptInclusion(subConcept, superConcept);
        }
        catch (UnsupportedOperationException e) {
            this.problems.add(e.getMessage());
            return null;
        }
    }

    private List<Axiom> transformOWLEquivalentClassesAxiom(OWLEquivalentClassesAxiom a) {
        ArrayList<Axiom> axioms = new ArrayList<Axiom>();
        List exps = a.getClassExpressionsAsList();
        int size = exps.size();
        for (int i = 0; i < size - 1; ++i) {
            try {
                OWLClassExpression e1 = (OWLClassExpression)exps.get(i);
                Concept concept1 = this.getConcept(e1);
                for (int j = i; j < size; ++j) {
                    OWLClassExpression e2 = (OWLClassExpression)exps.get(j);
                    if (e1 == e2) continue;
                    Concept concept2 = this.getConcept(e2);
                    axioms.add((Axiom)new ConceptInclusion(concept1, concept2));
                    axioms.add((Axiom)new ConceptInclusion(concept2, concept1));
                }
                continue;
            }
            catch (UnsupportedOperationException e) {
                this.problems.add(e.getMessage());
            }
        }
        return axioms;
    }

    private Axiom transformOWLDisjointClassesAxiom(OWLDisjointClassesAxiom a) {
        try {
            List exps = a.getClassExpressionsAsList();
            ArrayList<Concept> concepts = new ArrayList<Concept>();
            for (OWLClassExpression exp : exps) {
                concepts.add(this.getConcept(exp));
            }
            Concept[] conjs = new Concept[concepts.size()];
            for (int i = 0; i < concepts.size(); ++i) {
                conjs[i] = (Concept)concepts.get(i);
            }
            return new ConceptInclusion((Concept)new Conjunction(conjs), NamedConcept.BOTTOM_CONCEPT);
        }
        catch (UnsupportedOperationException e) {
            this.problems.add(e.getMessage());
            return null;
        }
    }

    private List<Axiom> transformOWLEquivalentObjectPropertiesAxiom(OWLEquivalentObjectPropertiesAxiom a) {
        ArrayList<Axiom> axioms = new ArrayList<Axiom>();
        for (OWLSubObjectPropertyOfAxiom ax : a.asSubObjectPropertyOfAxioms()) {
            OWLObjectPropertyExpression sub = (OWLObjectPropertyExpression)ax.getSubProperty();
            OWLObjectPropertyExpression sup = (OWLObjectPropertyExpression)ax.getSuperProperty();
            axioms.add((Axiom)new RoleInclusion((Role)new NamedRole(sub.asOWLObjectProperty().toStringID()), (Role)new NamedRole(sup.asOWLObjectProperty().toStringID())));
        }
        return axioms;
    }

    private Set<Axiom> transform(List<OWLAxiom> axioms, IProgressMonitor monitor) throws ImportException {
        monitor.taskStarted("Loading axioms");
        HashSet<Axiom> res = new HashSet<Axiom>();
        int totalAxioms = axioms.size();
        int workDone = 0;
        for (OWLAxiom axiom : axioms) {
            Axiom ax;
            OWLDeclarationAxiom a;
            if (axiom instanceof OWLDeclarationAxiom) {
                a = (OWLDeclarationAxiom)axiom;
                OWLEntity ent = a.getEntity();
                if (ent.isOWLClass()) {
                    res.add((Axiom)new ConceptInclusion((Concept)new NamedConcept(ent.asOWLClass().toStringID()), NamedConcept.TOP_CONCEPT));
                    continue;
                }
                if (!ent.isOWLObjectProperty() && !ent.isOWLDataProperty()) continue;
            }
            if (axiom instanceof OWLSubPropertyChainOfAxiom) {
                a = (OWLSubPropertyChainOfAxiom)axiom;
                ax = this.transformOWLSubPropertyChainOfAxiom((OWLSubPropertyChainOfAxiom)a);
                if (ax != null) {
                    res.add(ax);
                }
                monitor.step(workDone, totalAxioms);
                continue;
            }
            if (axiom instanceof OWLSubObjectPropertyOfAxiom) {
                a = (OWLSubObjectPropertyOfAxiom)axiom;
                res.add(this.transformOWLSubObjectPropertyOfAxiom((OWLSubObjectPropertyOfAxiom)a));
                monitor.step(++workDone, totalAxioms);
                continue;
            }
            if (axiom instanceof OWLReflexiveObjectPropertyAxiom) {
                a = (OWLReflexiveObjectPropertyAxiom)axiom;
                res.add(this.transformOWLReflexiveObjectPropertyAxiom((OWLReflexiveObjectPropertyAxiom)a));
                monitor.step(++workDone, totalAxioms);
                continue;
            }
            if (axiom instanceof OWLTransitiveObjectPropertyAxiom) {
                a = (OWLTransitiveObjectPropertyAxiom)axiom;
                res.add(this.transformOWLTransitiveObjectPropertyAxiom((OWLTransitiveObjectPropertyAxiom)a));
                monitor.step(++workDone, totalAxioms);
                continue;
            }
            if (axiom instanceof OWLSubClassOfAxiom) {
                a = (OWLSubClassOfAxiom)axiom;
                ax = this.transformOWLSubClassOfAxiom((OWLSubClassOfAxiom)a);
                if (ax != null) {
                    res.add(ax);
                }
                monitor.step(++workDone, totalAxioms);
                continue;
            }
            if (axiom instanceof OWLEquivalentClassesAxiom) {
                a = (OWLEquivalentClassesAxiom)axiom;
                res.addAll(this.transformOWLEquivalentClassesAxiom((OWLEquivalentClassesAxiom)a));
                monitor.step(++workDone, totalAxioms);
                continue;
            }
            if (axiom instanceof OWLDisjointClassesAxiom) {
                a = (OWLDisjointClassesAxiom)axiom;
                ax = this.transformOWLDisjointClassesAxiom((OWLDisjointClassesAxiom)a);
                if (ax != null) {
                    res.add(ax);
                }
                monitor.step(++workDone, totalAxioms);
                continue;
            }
            if (axiom instanceof OWLEquivalentObjectPropertiesAxiom) {
                a = (OWLEquivalentObjectPropertiesAxiom)axiom;
                res.addAll(this.transformOWLEquivalentObjectPropertiesAxiom((OWLEquivalentObjectPropertiesAxiom)a));
                monitor.step(++workDone, totalAxioms);
                continue;
            }
            if (axiom instanceof OWLAnnotationAssertionAxiom) {
                monitor.step(++workDone, totalAxioms);
                continue;
            }
            this.problems.add("The axiom " + axiom.toString() + " is not currently supported by Snorocket.");
        }
        monitor.taskEnded();
        return res;
    }

    private Set<Axiom> transform(OWLOntology ont, IProgressMonitor monitor) throws ImportException {
        return this.transform(Collections.list(Collections.enumeration(ont.getAxioms())), monitor);
    }

    private Literal getLiteral(OWLLiteral l) {
        OWLDatatype dt = l.getDatatype();
        String literal = l.getLiteral();
        StringLiteral res = null;
        if (dt.isBuiltIn()) {
            OWL2Datatype odt = dt.getBuiltInDatatype();
            switch (odt) {
                case RDF_PLAIN_LITERAL: 
                case RDF_XML_LITERAL: 
                case XSD_STRING: 
                case XSD_NORMALIZED_STRING: 
                case XSD_NAME: 
                case XSD_NCNAME: 
                case XSD_NMTOKEN: 
                case XSD_HEX_BINARY: 
                case XSD_BASE_64_BINARY: 
                case XSD_ANY_URI: 
                case XSD_TOKEN: {
                    res = new StringLiteral(literal);
                    break;
                }
                case XSD_INTEGER: 
                case XSD_NON_NEGATIVE_INTEGER: {
                    if (this.useSimpleInts) {
                        res = new IntegerLiteral(Integer.parseInt(literal));
                        break;
                    }
                    res = new BigIntegerLiteral(new BigInteger(literal));
                    break;
                }
                case XSD_DATE_TIME: {
                    res = new DateLiteral(DatatypeConverter.parseDateTime((String)literal));
                    break;
                }
                case OWL_RATIONAL: 
                case OWL_REAL: 
                case XSD_DECIMAL: {
                    if (this.useSimpleFloats) {
                        res = new FloatLiteral(Float.parseFloat(literal));
                        break;
                    }
                    res = new DecimalLiteral(new BigDecimal(literal));
                    break;
                }
                default: {
                    this.problems.add("Unsupported literal " + l);
                    break;
                }
            }
        } else {
            this.problems.add("Datatype is not built in: " + dt);
        }
        return res;
    }

    private void checkInconsistentProperty(OWLDataProperty dp, OWLDatatype type) {
        for (OWLDataPropertyRangeAxiom a : this.dprAxioms) {
            OWLDataPropertyExpression pe = (OWLDataPropertyExpression)a.getProperty();
            OWLDataRange r = (OWLDataRange)a.getRange();
            OWLDatatype otype = r.asOWLDatatype();
            if (!pe.isAnonymous()) {
                if (otype.equals(type)) continue;
                this.problems.add("The literal value restriction " + dp + " is inconsistent with the data property range axiom " + a);
                continue;
            }
            this.problems.add("Found anonymous data property expression in data property range axiom: " + pe);
        }
    }

    private Concept getConcept(OWLClassExpression desc) {
        final Stack stack = new Stack();
        desc.accept(new OWLClassExpressionVisitor(){

            private void unimplemented(OWLClassExpression e) {
                String message = "The class expression " + e.getClassExpressionType().getName() + " is not currently supported by Snorocket.";
                throw new UnsupportedOperationException(message);
            }

            private Concept pop() {
                return (Concept)stack.pop();
            }

            private void push(Concept concept) {
                stack.push(concept);
            }

            public void visit(OWLDataMaxCardinality e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLDataExactCardinality e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLDataMinCardinality e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLDataHasValue e) {
                OWLDataPropertyExpression dpe = e.getProperty();
                OWLDataProperty dp = dpe.asOWLDataProperty();
                OWLLiteral l = (OWLLiteral)e.getValue();
                OWLDatatype type = l.getDatatype();
                OWLImporter.this.checkInconsistentProperty(dp, type);
                NamedFeature f = new NamedFeature(dp.toStringID());
                Literal lit = OWLImporter.this.getLiteral(l);
                if (lit != null) {
                    this.push((Concept)new Datatype((Feature)f, Operator.EQUALS, lit));
                } else {
                    OWLImporter.this.problems.add("Axiom " + e + " will be ignored because of the unsupported literal.");
                }
            }

            public void visit(OWLDataAllValuesFrom e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLDataSomeValuesFrom e) {
                OWLDataProperty dp = e.getProperty().asOWLDataProperty();
                OWLDataRange range = (OWLDataRange)e.getFiller();
                if (range instanceof OWLDataOneOf) {
                    OWLDataOneOf doo = (OWLDataOneOf)range;
                    Set values = doo.getValues();
                    if (values.size() != 1) {
                        OWLImporter.this.problems.add("Expected only a single literal in " + e);
                        return;
                    }
                    OWLLiteral l = (OWLLiteral)values.toArray()[0];
                    OWLDatatype type = l.getDatatype();
                    OWLImporter.this.checkInconsistentProperty(dp, type);
                    NamedFeature f = new NamedFeature(dp.toStringID());
                    Literal lit = OWLImporter.this.getLiteral(l);
                    if (lit != null) {
                        this.push((Concept)new Datatype((Feature)f, Operator.EQUALS, lit));
                    } else {
                        OWLImporter.this.problems.add("Axiom " + e + " will be ignored because of the unsupported literal.");
                    }
                } else if (range instanceof OWLDatatypeRestriction) {
                    NamedFeature f = new NamedFeature(dp.toStringID());
                    OWLDatatypeRestriction dtr = (OWLDatatypeRestriction)range;
                    Set frs = dtr.getFacetRestrictions();
                    ArrayList<Datatype> conjuncts = new ArrayList<Datatype>();
                    for (OWLFacetRestriction fr : frs) {
                        OWLLiteral l = fr.getFacetValue();
                        Literal lit = OWLImporter.this.getLiteral(l);
                        if (lit != null) {
                            OWLImporter.this.checkInconsistentProperty(dp, l.getDatatype());
                            OWLFacet facet = fr.getFacet();
                            switch (facet) {
                                case MAX_EXCLUSIVE: {
                                    conjuncts.add(new Datatype((Feature)f, Operator.LESS_THAN, lit));
                                    break;
                                }
                                case MAX_INCLUSIVE: {
                                    conjuncts.add(new Datatype((Feature)f, Operator.LESS_THAN_EQUALS, lit));
                                    break;
                                }
                                case MIN_EXCLUSIVE: {
                                    conjuncts.add(new Datatype((Feature)f, Operator.GREATER_THAN, lit));
                                    break;
                                }
                                case MIN_INCLUSIVE: {
                                    conjuncts.add(new Datatype((Feature)f, Operator.GREATER_THAN_EQUALS, lit));
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("Unsupported facet " + facet);
                                }
                            }
                            continue;
                        }
                        OWLImporter.this.problems.add("Axiom " + e + " will be ignored because of the unsupported literal.");
                    }
                    if (conjuncts.size() == 1) {
                        this.push((Concept)conjuncts.get(0));
                    } else if (!conjuncts.isEmpty()) {
                        this.push((Concept)new Conjunction(conjuncts));
                    }
                } else {
                    throw new RuntimeException("Unsupporter OWLDataRange: " + range.getClass().getName());
                }
            }

            public void visit(OWLObjectOneOf e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectHasSelf e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectMaxCardinality e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectExactCardinality e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectMinCardinality e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectHasValue e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectAllValuesFrom e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectSomeValuesFrom e) {
                NamedRole r = new NamedRole(e.getProperty().asOWLObjectProperty().toStringID());
                ((OWLClassExpression)e.getFiller()).accept((OWLClassExpressionVisitor)this);
                try {
                    this.push((Concept)new Existential((Role)r, this.pop()));
                }
                catch (EmptyStackException ex) {
                    OWLImporter.this.problems.add("Unable to add axiom " + e + " because of previous problems.");
                }
            }

            public void visit(OWLObjectComplementOf e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectUnionOf e) {
                this.unimplemented((OWLClassExpression)e);
            }

            public void visit(OWLObjectIntersectionOf e) {
                ArrayList<Concept> items = new ArrayList<Concept>();
                for (OWLClassExpression desc : e.getOperands()) {
                    desc.accept((OWLClassExpressionVisitor)this);
                    try {
                        items.add(this.pop());
                    }
                    catch (EmptyStackException ex) {
                        OWLImporter.this.problems.add("Unable to add conjunct " + desc + " because of previous problems.");
                    }
                }
                if (!items.isEmpty()) {
                    Conjunction conj = new Conjunction(items);
                    this.push((Concept)conj);
                }
            }

            public void visit(OWLClass e) {
                String id = e.toStringID();
                if ("<http://www.w3.org/2002/07/owl#Thing>".equals(id) || OWLImporter.THING_IRI.equals(id)) {
                    this.push(NamedConcept.TOP_CONCEPT);
                } else if ("<http://www.w3.org/2002/07/owl#Nothing>".equals(id) || OWLImporter.NOTHING_IRI.equals(id)) {
                    this.push(NamedConcept.BOTTOM_CONCEPT);
                } else {
                    this.push((Concept)new NamedConcept(id));
                }
            }
        });
        if (stack.size() != 1) {
            throw new RuntimeException("Stack size should be 1 but is " + stack.size());
        }
        return (Concept)stack.pop();
    }

    public void clear() {
        this.dprAxioms.clear();
        this.problems.clear();
    }

    @Override
    public List<String> getProblems() {
        return this.problems;
    }

    @Override
    public Iterator<Ontology> getOntologyVersions(IProgressMonitor monitor) {
        return new OntologyInterator(monitor);
    }

    class OntologyInterator
    implements Iterator<Ontology> {
        private boolean accessed = false;
        private IProgressMonitor monitor;

        public OntologyInterator(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public boolean hasNext() {
            return !this.accessed;
        }

        @Override
        public Ontology next() throws IllegalArgumentException, RuntimeException {
            Set ont;
            long start;
            block4: {
                start = System.currentTimeMillis();
                ont = null;
                try {
                    if (OWLImporter.this.ontology != null) {
                        ont = OWLImporter.this.transform(OWLImporter.this.ontology, this.monitor);
                        break block4;
                    }
                    if (OWLImporter.this.axioms != null) {
                        ont = OWLImporter.this.transform(OWLImporter.this.axioms, this.monitor);
                        break block4;
                    }
                    throw new IllegalArgumentException("No OWL ontology to transform.");
                }
                catch (ImportException e) {
                    throw new RuntimeException(e);
                }
            }
            String id = null;
            id = OWLImporter.this.ontology != null ? OWLImporter.this.ontology.getOntologyID().toString() : "incremental";
            String version = OWLImporter.this.sdf.format(new Date());
            Ontology res = new Ontology(id, version, (Collection)ont, null);
            Statistics.INSTANCE.setTime("owl loading", System.currentTimeMillis() - start);
            this.accessed = true;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

