/*
 * Decompiled with CFR 0.152.
 */
package au.com.turingg.disks;

import au.com.turingg.disks.DirectoryScanner;
import au.com.turingg.disks.PathVisitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class SequentialDirectoryScanner
implements DirectoryScanner {
    private final PathVisitor pathVisitor;

    public SequentialDirectoryScanner(PathVisitor pathVisitor) {
        this.pathVisitor = pathVisitor;
    }

    @Override
    public void start(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("[%s] is not a directory", directory.toAbsolutePath().toString()));
        }
        Files.walkFileTree(directory, this.pathVisitor);
    }
}

