/*
 * Decompiled with CFR 0.152.
 */
package au.com.turingg.disks;

import au.com.turingg.disks.ExtendedPath;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.tika.Tika;

public class PathVisitor
implements FileVisitor<Path> {
    private final Tika tika = new Tika();
    private final Consumer<ExtendedPath> consumer;
    private final BiConsumer<Path, IOException> errorHandler;

    public PathVisitor(Consumer<ExtendedPath> consumer, BiConsumer<Path, IOException> errorHandler) {
        this.consumer = consumer;
        this.errorHandler = errorHandler;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        ExtendedPath ep = new ExtendedPath(dir);
        this.consumer.accept(ep);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        String mimeType = this.detectMimeType(path).orElse(null);
        ExtendedPath ep = new ExtendedPath(path, mimeType);
        this.consumer.accept(ep);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException ex) throws IOException {
        this.errorHandler.accept(file, ex);
        if (Files.isDirectory(file, new LinkOption[0])) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
        if (ex != null) {
            this.errorHandler.accept(dir, ex);
        }
        return FileVisitResult.CONTINUE;
    }

    private Optional<String> detectMimeType(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return Optional.of("inode/irregular-file");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return Optional.of("inode/directory");
        }
        try {
            String mimeType = this.tika.detect(path.toFile());
            return Optional.of(mimeType);
        }
        catch (IOException ioe) {
            this.errorHandler.accept(path, ioe);
            return Optional.empty();
        }
    }
}

