/*
 * Decompiled with CFR 0.152.
 */
package au.com.turingg.disks;

import au.com.turingg.disks.FileType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ExtendedPath {
    private final String name;
    private final String absolutePath;
    private final String extension;
    private final String mimeType;
    private final Long size;
    private final FileType type;

    public ExtendedPath(String name, String absolutePath, String extension, String mimeType, FileType type, Long size) {
        this.name = name;
        this.absolutePath = absolutePath;
        this.extension = extension;
        this.mimeType = mimeType;
        this.type = type;
        this.size = size;
    }

    public ExtendedPath(Path path, String mimeType) {
        File file = path.toFile();
        this.name = file.getName();
        this.absolutePath = file.getAbsolutePath();
        this.extension = FilenameUtils.getExtension((String)this.absolutePath);
        this.mimeType = mimeType;
        this.type = Files.isDirectory(path, new LinkOption[0]) ? FileType.DIRECTORY : (Files.isRegularFile(path, new LinkOption[0]) ? FileType.REGULAR_FILE : FileType.OTHER);
        this.size = file.length();
    }

    public ExtendedPath(Path path) {
        this(path, null);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public FileType getType() {
        return this.type;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

