/*
 * Decompiled with CFR 0.152.
 */
package au.com.timmutton.redexplugin;

import au.com.timmutton.redexplugin.DexFile;
import au.com.timmutton.redexplugin.internal.RedexConfiguration;
import au.com.timmutton.redexplugin.internal.RedexConfigurationContainer;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.builder.model.SigningConfig;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.InputFile;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lau/com/timmutton/redexplugin/RedexTask;", "Lorg/gradle/api/tasks/Exec;", "()V", "inputFile", "Ljava/io/File;", "mappingFile", "signingConfig", "Lcom/android/builder/model/SigningConfig;", "exec", "", "initialise", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "Companion", "redex_main"})
public class RedexTask
extends Exec {
    private SigningConfig signingConfig;
    @InputFile
    private File inputFile;
    private File mappingFile;
    private static final String TASK_GROUP = "Optimisation";
    @Nullable
    private static String[] passes;
    @Nullable
    private static String sdkDirectory;
    @Nullable
    private static String configFilePath;
    public static final Companion Companion;

    public final void initialise(@NotNull ApplicationVariant variant) {
        Object element$iv2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
            this.setGroup(RedexTask.Companion.getTASK_GROUP());
            this.setDescription("Run Redex tool on your " + StringsKt.capitalize((String)variant.getName()) + " apk");
            this.signingConfig = variant.getBuildType().getSigningConfig();
            this.mustRunAfter(new Object[]{variant.getAssemble()});
            Iterable $receiver$iv = variant.getOutputs();
            for (Object element$iv2 : $receiver$iv) {
                BaseVariantOutput it = (BaseVariantOutput)element$iv2;
                if (!StringsKt.endsWith$default((String)it.getOutputFile().getName(), (String)".apk", (boolean)false, (int)2, null)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        BaseVariantOutput output = (BaseVariantOutput)element$iv2;
        File file = output.getOutputFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output.outputFile");
        this.inputFile = file;
        this.mappingFile = variant.getMappingFile();
        if (Companion.getPasses() != null && Companion.getConfigFilePath() != null) {
            throw (Throwable)new IllegalArgumentException("Cannot specify both passes and configFilePath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void exec() {
        int n;
        Object it;
        int n2;
        Iterable $receiver$iv;
        SigningConfig $receiver;
        SigningConfig signingConfig;
        SigningConfig signingConfig2 = Companion.getSdkDirectory();
        if (signingConfig2 != null) {
            $receiver = signingConfig = signingConfig2;
            this.environment("ANDROID_SDK", Companion.getSdkDirectory());
        }
        SigningConfig signingConfig3 = Companion.getPasses();
        if (signingConfig3 != null) {
            Object[] $i$a$1$apply;
            Object[] objectArray;
            $receiver = signingConfig = signingConfig3;
            String[] stringArray = Companion.getPasses();
            if (stringArray == null) {
                Intrinsics.throwNpe();
            }
            if (!((objectArray = ($i$a$1$apply = (Object[])stringArray)).length == 0)) {
                String configString;
                Gson gson = new Gson();
                String[] stringArray2 = Companion.getPasses();
                if (stringArray2 == null) {
                    Intrinsics.throwNpe();
                }
                String redexConfig = gson.toJson((Object)new RedexConfigurationContainer(new RedexConfiguration(stringArray2)));
                File configFile = new File(this.getProject().getBuildDir(), "redex.config");
                configFile.createNewFile();
                FileWriter writer = new FileWriter(configFile);
                String string = configString = new Gson().toJson((Object)redexConfig);
                int n3 = 1;
                int n4 = configString.length() - 1;
                Iterator iterator = writer;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n3, n4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = string3;
                ((Writer)((Object)iterator)).write(StringsKt.replace$default((String)string4, (String)"\\", (String)"", (boolean)false, (int)4, null));
                writer.close();
                this.args(new Object[]{"-c", configFile.getAbsolutePath()});
            }
        }
        String string = Companion.getConfigFilePath();
        if (string != null) {
            $receiver = signingConfig = string;
            File configFile = new File(this.getProject().getProjectDir(), Companion.getConfigFilePath());
            if (!configFile.exists()) {
                throw (Throwable)new FileNotFoundException("Could not find Redex config file at path: " + configFile.getAbsolutePath());
            }
            this.args(new Object[]{"-c", configFile.getAbsolutePath()});
        }
        SigningConfig signingConfig4 = this.signingConfig;
        if (signingConfig4 != null) {
            $receiver = signingConfig = signingConfig4;
            Object[] objectArray = new Object[7];
            objectArray[0] = "--sign";
            objectArray[1] = "--keystore";
            SigningConfig signingConfig5 = this.signingConfig;
            if (signingConfig5 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[2] = signingConfig5.getStoreFile().getAbsolutePath();
            objectArray[3] = "--keyalias";
            SigningConfig signingConfig6 = this.signingConfig;
            if (signingConfig6 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[4] = signingConfig6.getKeyAlias();
            objectArray[5] = "--keypass";
            SigningConfig signingConfig7 = this.signingConfig;
            if (signingConfig7 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[6] = signingConfig7.getKeyPassword();
            this.args(objectArray);
        }
        File file = this.inputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        }
        String original = file.toString();
        File file2 = this.inputFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        }
        file2.renameTo(new File(StringsKt.replace$default((String)original, (String)".apk", (String)"-unredexed.apk", (boolean)false, (int)4, null)));
        File outputFile = new File(original);
        Object[] objectArray = new Object[3];
        objectArray[0] = "-o";
        objectArray[1] = String.valueOf(outputFile);
        File file3 = this.inputFile;
        if (file3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        }
        objectArray[2] = String.valueOf(file3);
        this.args(objectArray);
        this.executable("redex");
        if (this.mappingFile != null) {
            File file4 = this.mappingFile;
            if (file4 == null) {
                Intrinsics.throwNpe();
            }
            if (!file4.exists()) {
                Logger logger = this.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Mapping file specified at ");
                File file5 = this.mappingFile;
                if (file5 == null) {
                    Intrinsics.throwNpe();
                }
                logger.log(LogLevel.INFO, stringBuilder.append(file5.getAbsolutePath()).append(" does not exist, assuming output is not obfuscated.").toString());
                this.mappingFile = null;
            }
        }
        boolean showStats = true;
        int startingMethods = 0;
        int startingFields = 0;
        int startingSize = 0;
        File file6 = this.inputFile;
        if (file6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        }
        List<DexFile> originalDexData = DexFile.Companion.extractDexData(file6);
        try {
            $receiver$iv = originalDexData;
            int sum$iv = 0;
            for (Object element$iv : $receiver$iv) {
                DexFile $i$a$2$apply = (DexFile)element$iv;
                n2 = sum$iv;
                n = ((Object[])((DexFile)it).getData().getMethodRefs()).length;
                sum$iv = n2 + n;
            }
            startingMethods = sum$iv;
            $receiver$iv = originalDexData;
            sum$iv = 0;
            for (Object element$iv : $receiver$iv) {
                it = (DexFile)element$iv;
                n2 = sum$iv;
                n = ((Object[])((DexFile)it).getData().getFieldRefs()).length;
                sum$iv = n2 + n;
            }
            startingFields = sum$iv;
            File file7 = this.inputFile;
            if (file7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
            }
            startingSize = (int)file7.length();
        }
        catch (Exception e) {
            showStats = false;
        }
        finally {
            $receiver$iv = originalDexData;
            for (Iterator element$iv : $receiver$iv) {
                DexFile it2 = (DexFile)((Object)element$iv);
                it2.dispose();
            }
        }
        if (showStats) {
            this.getLogger().log(LogLevel.LIFECYCLE, "\n" + "Before redex:" + "\n" + "\t" + startingMethods + " methods" + "\n" + "\t" + startingFields + " fields" + "\n" + "\t" + startingSize + " bytes");
        }
        try {
            super.exec();
            if (showStats) {
                List<DexFile> newDexData = DexFile.Companion.extractDexData(outputFile);
                try {
                    Object element$iv3;
                    Object[] it3;
                    Iterable $receiver$iv2 = newDexData;
                    int sum$iv22 = 0;
                    for (Object element$iv2 : $receiver$iv2) {
                        DexFile $i$f$forEach = (DexFile)element$iv2;
                        n2 = sum$iv22;
                        n = ((Object[])it3.getData().getMethodRefs()).length;
                        sum$iv22 = n2 + n;
                    }
                    int methods = sum$iv22;
                    String sum$iv22 = "%.2f";
                    it = new Object[]{Float.valueOf((float)methods / (float)startingMethods * 100.0f)};
                    String string5 = String.format(sum$iv22, Arrays.copyOf(it, ((Object[])it).length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(this, *args)");
                    String methodPercentage = string5;
                    Iterable $receiver$iv3 = newDexData;
                    int sum$iv32 = 0;
                    for (Object element$iv3 : $receiver$iv3) {
                        void it4;
                        DexFile $i$f$sumBy = (DexFile)element$iv3;
                        n2 = sum$iv32;
                        n = ((Object[])it4.getData().getFieldRefs()).length;
                        sum$iv32 = n2 + n;
                    }
                    int fields = sum$iv32;
                    String sum$iv32 = "%.2f";
                    it3 = new Object[]{Float.valueOf((float)fields / (float)startingFields * 100.0f)};
                    String string6 = String.format(sum$iv32, Arrays.copyOf(it3, it3.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(this, *args)");
                    String fieldPercentage = string6;
                    int size = (int)outputFile.length();
                    element$iv3 = "%.2f";
                    Object[] objectArray2 = new Object[]{Float.valueOf((float)size / (float)startingSize * 100.0f)};
                    String string7 = String.format(element$iv3, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(this, *args)");
                    String sizePercentage = string7;
                    this.getLogger().log(LogLevel.LIFECYCLE, "After redex:");
                    this.getLogger().log(LogLevel.LIFECYCLE, "\t" + methods + " methods (%" + (String)methodPercentage + " of original)");
                    this.getLogger().log(LogLevel.LIFECYCLE, "\t" + fields + " fields (%" + fieldPercentage + " of original)");
                    this.getLogger().log(LogLevel.LIFECYCLE, "\t" + size + " bytes (%" + sizePercentage + " of original)");
                }
                finally {
                    Iterable $receiver$iv4 = newDexData;
                    for (Object element$iv : $receiver$iv4) {
                        it = (DexFile)element$iv;
                        ((DexFile)it).dispose();
                    }
                }
            }
        }
        catch (ExecException e) {
            if (e.getMessage() != null) {
                String string8 = e.getMessage();
                if (string8 == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"A problem occurred starting process", (boolean)false, (int)2, null)) {
                    throw (Throwable)new ExecException("A problem occurred starting Redex. Ensure you have installed Redex using the instructions at https://github.com/facebook/redex");
                }
            }
            throw (Throwable)e;
        }
    }

    static {
        Companion = new Companion(null);
        TASK_GROUP = TASK_GROUP;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR$\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\n\u00a8\u0006\u0015"}, d2={"Lau/com/timmutton/redexplugin/RedexTask$Companion;", "", "()V", "TASK_GROUP", "", "getTASK_GROUP", "()Ljava/lang/String;", "configFilePath", "getConfigFilePath", "setConfigFilePath", "(Ljava/lang/String;)V", "passes", "", "getPasses", "()[Ljava/lang/String;", "setPasses", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "sdkDirectory", "getSdkDirectory", "setSdkDirectory", "redex_main"})
    public static final class Companion {
        private final String getTASK_GROUP() {
            return TASK_GROUP;
        }

        @Nullable
        public final String[] getPasses() {
            return passes;
        }

        public final void setPasses(@Nullable String[] stringArray) {
            passes = stringArray;
        }

        @Nullable
        public final String getSdkDirectory() {
            return sdkDirectory;
        }

        public final void setSdkDirectory(@Nullable String string) {
            sdkDirectory = string;
        }

        @Nullable
        public final String getConfigFilePath() {
            return configFilePath;
        }

        public final void setConfigFilePath(@Nullable String string) {
            configFilePath = string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

