/*
 * Decompiled with CFR 0.152.
 */
package au.com.timmutton.redexplugin;

import au.com.timmutton.redexplugin.internal.RedexConfiguration;
import au.com.timmutton.redexplugin.internal.RedexConfigurationContainer;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.builder.model.SigningConfig;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0014J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lau/com/timmutton/redexplugin/RedexTask;", "Lorg/gradle/api/tasks/Exec;", "()V", "inputFile", "Ljava/io/File;", "outputFile", "signingConfig", "Lcom/android/builder/model/SigningConfig;", "exec", "", "initialise", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "Companion", "redex-compileKotlin"})
public class RedexTask
extends Exec {
    private SigningConfig signingConfig;
    @InputFile
    private File inputFile;
    @OutputFile
    private File outputFile;
    private static final String TASK_GROUP = "Optimisation";
    @Nullable
    private static String[] passes;
    @Nullable
    private static String sdkDirectory;
    public static final Companion Companion;

    public final void initialise(@NotNull ApplicationVariant variant) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        this.setGroup(RedexTask.Companion.getTASK_GROUP());
        this.setDescription("Run Redex tool on your " + StringsKt.capitalize((String)variant.getName()) + " apk");
        this.signingConfig = variant.getBuildType().getSigningConfig();
        this.mustRunAfter(new Object[]{variant.getAssemble()});
        BaseVariantOutput output = (BaseVariantOutput)variant.getOutputs().get(0);
        File file = output.getOutputFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output.outputFile");
        this.inputFile = file;
        this.outputFile = new File(StringsKt.replace$default((String)output.getOutputFile().toString(), (String)".apk", (String)"-redex.apk", (boolean)false, (int)4, null));
    }

    /*
     * WARNING - void declaration
     */
    protected void exec() {
        SigningConfig signingConfig;
        String[] stringArray;
        String string;
        SigningConfig $receiver;
        SigningConfig $receiver$iv;
        SigningConfig signingConfig2 = Companion.getSdkDirectory();
        if (signingConfig2 != null) {
            $receiver$iv = signingConfig2;
            $receiver = $receiver$iv;
            this.environment("ANDROID_SDK", Companion.getSdkDirectory());
            string = (String)$receiver$iv;
        } else {
            string = null;
        }
        SigningConfig signingConfig3 = Companion.getPasses();
        if (signingConfig3 != null) {
            $receiver$iv = signingConfig3;
            $receiver = $receiver$iv;
            String[] stringArray2 = Companion.getPasses();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            if (((Object[])stringArray2).length > 0) {
                void endIndex$iv;
                void startIndex$iv;
                void $receiver$iv2;
                String configString;
                Gson gson = new Gson();
                String[] stringArray3 = Companion.getPasses();
                if (stringArray3 == null) {
                    Intrinsics.throwNpe();
                }
                String redexConfig = gson.toJson((Object)new RedexConfigurationContainer(new RedexConfiguration(stringArray3)));
                File configFile = new File(this.getProject().getBuildDir(), "redex.config");
                configFile.createNewFile();
                FileWriter writer = new FileWriter(configFile);
                String string2 = configString = new Gson().toJson((Object)redexConfig);
                boolean bl = true;
                int n = configString.length() - 1;
                FileWriter fileWriter = writer;
                void v6 = $receiver$iv2;
                if (v6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)v6).substring((int)startIndex$iv, (int)endIndex$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = string3;
                fileWriter.write(StringsKt.replace$default((String)string4, (String)"\\", (String)"", (boolean)false, (int)4, null));
                writer.close();
                this.args(new Object[]{"-c", configFile.getAbsolutePath()});
            }
            stringArray = (String[])$receiver$iv;
        } else {
            stringArray = null;
        }
        SigningConfig signingConfig4 = this.signingConfig;
        if (signingConfig4 != null) {
            $receiver$iv = signingConfig4;
            $receiver = $receiver$iv;
            Object[] objectArray = new Object[7];
            objectArray[0] = "--sign";
            objectArray[1] = "--keystore";
            SigningConfig signingConfig5 = this.signingConfig;
            if (signingConfig5 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[2] = signingConfig5.getStoreFile().getAbsolutePath();
            objectArray[3] = "--keyalias";
            SigningConfig signingConfig6 = this.signingConfig;
            if (signingConfig6 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[4] = signingConfig6.getKeyAlias();
            objectArray[5] = "--keypass";
            SigningConfig signingConfig7 = this.signingConfig;
            if (signingConfig7 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[6] = signingConfig7.getKeyPassword();
            this.args(objectArray);
            signingConfig = $receiver$iv;
        } else {
            signingConfig = null;
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = "-o";
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        objectArray[1] = String.valueOf(file);
        File file2 = this.inputFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        }
        objectArray[2] = String.valueOf(file2);
        this.args(objectArray);
        this.executable("redex");
        try {
            super.exec();
        }
        catch (ExecException e) {
            if (e.getMessage() != null) {
                String string5 = e.getMessage();
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"A problem occurred starting process", (boolean)false, (int)2, null)) {
                    throw (Throwable)new ExecException("A problem occurred starting Redex. " + "Ensure you have installed Redex using the instructions at https://github.com/facebook/redex");
                }
            }
            throw (Throwable)e;
        }
    }

    static {
        Companion = new Companion(null);
        TASK_GROUP = TASK_GROUP;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lau/com/timmutton/redexplugin/RedexTask$Companion;", "", "()V", "TASK_GROUP", "", "getTASK_GROUP", "()Ljava/lang/String;", "passes", "", "getPasses", "()[Ljava/lang/String;", "setPasses", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "sdkDirectory", "getSdkDirectory", "setSdkDirectory", "(Ljava/lang/String;)V", "redex-compileKotlin"})
    public static final class Companion {
        private final String getTASK_GROUP() {
            return TASK_GROUP;
        }

        @Nullable
        public final String[] getPasses() {
            return passes;
        }

        public final void setPasses(@Nullable String[] stringArray) {
            passes = stringArray;
        }

        @Nullable
        public final String getSdkDirectory() {
            return sdkDirectory;
        }

        public final void setSdkDirectory(@Nullable String string) {
            sdkDirectory = string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

