/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.schedulerclient;

import com.skytix.schedulerclient.HttpLeaderResolver;
import com.skytix.schedulerclient.LeaderResolver;
import com.skytix.schedulerclient.NoLeaderException;
import com.skytix.schedulerclient.SchedulerConfig;
import com.skytix.schedulerclient.SchedulerEventHandler;
import com.skytix.schedulerclient.SchedulerRemote;
import com.skytix.schedulerclient.ZooKeeperLeaderResolver;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.lf5.util.StreamUtils;
import org.apache.mesos.v1.Protos;
import org.apache.mesos.v1.scheduler.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scheduler
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Scheduler.class);
    private static final Semaphore mSemaphore = new Semaphore(0);
    private final Protos.FrameworkID mFrameworkId;
    private final SchedulerConfig mConfig;
    private final HttpClient mHttpClient;
    private final SchedulerEventHandler mSchedulerEventHandler;
    private final LeaderResolver mLeaderResolver;
    private ScheduledExecutorService mExecutorService = null;
    private SchedulerRemote mRemote;
    private String mMesosStreamID = null;
    private String mMasterURL = null;
    private ScheduledFuture<?> mClientThread;
    private boolean mRunning = true;
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public static Scheduler newScheduler(String aFrameworkId, String aMesosMasterURI, SchedulerEventHandler aEventHandler) throws IOException {
        return Scheduler.newScheduler(((SchedulerConfig.SchedulerConfigBuilder)((SchedulerConfig.SchedulerConfigBuilder)SchedulerConfig.builder().frameworkID(aFrameworkId)).mesosMasterURL(aMesosMasterURI)).build(), aEventHandler);
    }

    public static Scheduler newScheduler(SchedulerConfig aConfig, SchedulerEventHandler aEventHandler) throws IOException {
        return Scheduler.newScheduler(aConfig, aEventHandler, Executors.newScheduledThreadPool(1));
    }

    public static Scheduler newScheduler(SchedulerConfig aConfig, SchedulerEventHandler aEventHandler, ScheduledExecutorService aExecutorService) throws IOException {
        Scheduler scheduler = new Scheduler(aConfig, aEventHandler);
        scheduler.init(aExecutorService);
        return scheduler;
    }

    private Scheduler(SchedulerConfig aConfig, SchedulerEventHandler aEventHandler) {
        Protos.FrameworkID.Builder frameworkID = Protos.FrameworkID.newBuilder();
        if (StringUtils.isEmpty((CharSequence)aConfig.getFrameworkID())) {
            frameworkID.setValue(UUID.randomUUID().toString());
        } else {
            frameworkID.setValue(aConfig.getFrameworkID());
        }
        this.mConfig = aConfig;
        this.mFrameworkId = frameworkID.build();
        this.mSchedulerEventHandler = aEventHandler;
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (this.mConfig.isDisableSSLTrust()) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                httpClientBuilder.sslContext(sslContext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException aE) {
                log.error("Unable to set SSLContext.  Skipping disabling of SSL Trust checking.");
            }
        }
        this.mHttpClient = httpClientBuilder.build();
        String masterURL = aConfig.getMesosMasterURL();
        if (StringUtils.isNotEmpty((CharSequence)masterURL)) {
            this.mLeaderResolver = masterURL.startsWith("zk") ? new ZooKeeperLeaderResolver() : new HttpLeaderResolver(masterURL, this.mHttpClient);
        } else {
            throw new IllegalArgumentException("mesosMasterURL configuration is required");
        }
    }

    private void init(ScheduledExecutorService aThreadExecutorService) throws IOException {
        this.mExecutorService = aThreadExecutorService;
        try {
            Protos.FrameworkInfo.Builder frameworkInfo = this.createFrameworkInfo();
            Protos.Call subscribeCall = Protos.Call.newBuilder().setFrameworkId(this.mFrameworkId).setType(Protos.Call.Type.SUBSCRIBE).setSubscribe(Protos.Call.Subscribe.newBuilder().setFrameworkInfo(frameworkInfo)).build();
            String leader = this.mLeaderResolver.resolveLeader();
            URI leaderUri = new URI(leader + "/api/v1/scheduler");
            HttpRequest request = HttpRequest.newBuilder().uri(leaderUri).header("Content-Type", "application/x-protobuf").header("Accept", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray(subscribeCall.toByteArray())).build();
            log.info(String.format("Connecting to Mesos at: %s", leaderUri));
            HttpResponse<InputStream> response = this.mHttpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                throw new IOException(String.format("Scheduler was unable to connect to mesos with exit code %d - %s", response.statusCode(), new String(StreamUtils.getBytes((InputStream)response.body()))));
            }
            this.mMesosStreamID = response.headers().firstValue("Mesos-Stream-Id").get();
            log.info(String.format("Connected with Stream ID: %s", this.mMesosStreamID));
            this.mMasterURL = leader;
            this.mRemote = new SchedulerRemote(this);
            this.mClientThread = this.mExecutorService.schedule(() -> {
                try {
                    BufferedInputStream reader = new BufferedInputStream((InputStream)response.body());
                    boolean subscribed = false;
                    StringBuffer sb = new StringBuffer();
                    int data = ((InputStream)reader).read();
                    while (data != -1 && this.mRunning) {
                        if (data == 10) {
                            long recordLength = Long.parseLong(sb.toString());
                            byte[] buffer = reader.readNBytes((int)recordLength);
                            Protos.Event event = Protos.Event.parseFrom((byte[])buffer);
                            switch (event.getType()) {
                                case SUBSCRIBED: {
                                    this.mSchedulerEventHandler.onSubscribe(this.mRemote, event.getSubscribed());
                                    subscribed = true;
                                    log.info(String.format("Connected to Master as FrameworkID: %s", this.mFrameworkId.getValue()));
                                    break;
                                }
                                case ERROR: {
                                    if (!subscribed) {
                                        String error = String.format("Error subscribing to Mesos: %s", event.getMessage());
                                        log.error(error);
                                        this.mSchedulerEventHandler.onTerminate(new IllegalStateException(error));
                                        break;
                                    }
                                    this.mSchedulerEventHandler.handleEvent(event);
                                    break;
                                }
                                default: {
                                    this.mSchedulerEventHandler.handleEvent(event);
                                }
                            }
                            sb = new StringBuffer();
                            data = ((InputStream)reader).read();
                            continue;
                        }
                        sb.append(new String(new byte[]{(byte)data}));
                        data = ((InputStream)reader).read();
                    }
                    if (this.mRunning) {
                        log.info(String.format("Scheduler '%s' has lost it's connection to Mesos '%s'", this.mFrameworkId, this.mMasterURL));
                        this.mSchedulerEventHandler.onDisconnect();
                    } else {
                        this.mSchedulerEventHandler.onExit();
                    }
                }
                catch (IOException aE) {
                    this.mSchedulerEventHandler.onTerminate(aE);
                }
                finally {
                    mSemaphore.release();
                }
            }, 0L, TimeUnit.SECONDS);
        }
        catch (NoLeaderException | InterruptedException | URISyntaxException aE) {
            throw new IOException(aE);
        }
    }

    public void join() throws InterruptedException {
        mSemaphore.acquire();
    }

    public String getMesosMasterURL() {
        return this.mMasterURL;
    }

    public SchedulerRemote getRemote() {
        return this.mRemote;
    }

    private Protos.FrameworkInfo.Builder createFrameworkInfo() {
        Protos.FrameworkInfo.Builder frameworkInfo = Protos.FrameworkInfo.newBuilder().setId(this.mFrameworkId);
        if (StringUtils.isBlank((CharSequence)this.mConfig.getUser())) {
            frameworkInfo.setUser("root");
        } else {
            frameworkInfo.setUser(this.mConfig.getUser());
        }
        if (StringUtils.isBlank((CharSequence)this.mConfig.getName())) {
            frameworkInfo.setName("mesos-scheduler-client");
        } else {
            frameworkInfo.setName(this.mConfig.getName());
        }
        if (this.mConfig.getFailoverTimeout() > 0.0) {
            frameworkInfo.setFailoverTimeout(this.mConfig.getFailoverTimeout());
        }
        if (this.mConfig.getRoles() != null && !this.mConfig.getRoles().isEmpty()) {
            frameworkInfo.addAllRoles(this.mConfig.getRoles());
        }
        if (this.mConfig.isEnableGPUResources()) {
            Protos.FrameworkInfo.Capability.Builder capabilityBuilder = Protos.FrameworkInfo.Capability.newBuilder();
            capabilityBuilder.setType(Protos.FrameworkInfo.Capability.Type.GPU_RESOURCES);
            frameworkInfo.addCapabilities(capabilityBuilder);
        }
        return frameworkInfo;
    }

    @Override
    public void close() throws IOException {
        this.mRunning = false;
        this.mExecutorService.shutdown();
        this.mClientThread.cancel(false);
    }

    protected Protos.FrameworkID getFrameworkID() {
        return this.mFrameworkId;
    }

    protected void sendCall(Protos.Call aCall) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(this.mMasterURL + "/api/v1/scheduler")).header("Content-Type", "application/x-protobuf").header("Mesos-Stream-Id", this.mMesosStreamID).POST(HttpRequest.BodyPublishers.ofByteArray(aCall.toByteArray())).build();
            HttpResponse<String> response = this.mHttpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 202) {
                log.error("Error sending call to Mesos: " + response.body());
            }
        }
        catch (IOException | InterruptedException | URISyntaxException aE) {
            aE.printStackTrace();
        }
    }

    protected Protos.Call.Builder createCall(Protos.Call.Type aType) {
        return Protos.Call.newBuilder().setFrameworkId(this.mFrameworkId).setType(aType);
    }
}

