/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.schedulerclient;

import com.skytix.schedulerclient.Scheduler;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.mesos.v1.Protos;
import org.apache.mesos.v1.scheduler.Protos;

public final class SchedulerRemote {
    private final Scheduler mScheduler;

    protected SchedulerRemote(Scheduler aScheduler) {
        this.mScheduler = aScheduler;
    }

    public void exit() throws IOException {
        this.mScheduler.close();
    }

    public String getMesosMasterURL() {
        return this.mScheduler.getMesosMasterURL();
    }

    public Protos.FrameworkID getFrameworkID() {
        return this.mScheduler.getFrameworkID();
    }

    public void accept(List<Protos.OfferID> aOfferIDs, List<Protos.Offer.Operation> aOperations) {
        this.accept(aOfferIDs, aOperations, null);
    }

    public void accept(List<Protos.OfferID> aOfferIDs, List<Protos.Offer.Operation> aOperations, Double aRefuseSeconds) {
        Protos.Call.Accept.Builder acceptBuilder = Protos.Call.Accept.newBuilder().addAllOfferIds(aOfferIDs).addAllOperations(aOperations);
        if (aRefuseSeconds != null) {
            acceptBuilder.setFilters(Protos.Filters.newBuilder().setRefuseSeconds(aRefuseSeconds.doubleValue()));
        }
        this.mScheduler.sendCall(this.mScheduler.createCall(Protos.Call.Type.ACCEPT).setAccept(acceptBuilder).build());
    }

    public void acknowledge(Protos.TaskStatusOrBuilder aTaskStatus) {
        this.mScheduler.sendCall(this.mScheduler.createCall(Protos.Call.Type.ACKNOWLEDGE).setAcknowledge(Protos.Call.Acknowledge.newBuilder().setAgentId(aTaskStatus.getAgentId()).setTaskId(aTaskStatus.getTaskId()).setUuid(aTaskStatus.getUuid())).build());
    }

    public void acknowledgeOperationStatus(Protos.OperationStatusOrBuilder aOperationStatus) {
        this.mScheduler.sendCall(this.createCall(Protos.Call.Type.ACKNOWLEDGE_OPERATION_STATUS).setAcknowledgeOperationStatus(Protos.Call.AcknowledgeOperationStatus.newBuilder().setAgentId(aOperationStatus.getAgentId()).setResourceProviderId(aOperationStatus.getResourceProviderId()).setUuid(aOperationStatus.getUuid().getValue()).setOperationId(aOperationStatus.getOperationId())).build());
    }

    public void decline(List<Protos.OfferID> aOfferIDs) {
        this.decline(aOfferIDs, null);
    }

    public void decline(List<Protos.OfferID> aOfferIDs, Double aRefuseSeconds) {
        Protos.Call.Decline.Builder declineBuilder = Protos.Call.Decline.newBuilder().addAllOfferIds(aOfferIDs);
        if (aRefuseSeconds != null) {
            declineBuilder.setFilters(Protos.Filters.newBuilder().setRefuseSeconds(aRefuseSeconds.doubleValue()));
        }
        this.mScheduler.sendCall(this.createCall(Protos.Call.Type.DECLINE).setDecline(declineBuilder).build());
    }

    public void kill(Protos.TaskID aTaskID, Protos.AgentID aAgentID) {
        this.mScheduler.sendCall(this.createCall(Protos.Call.Type.KILL).setKill(Protos.Call.Kill.newBuilder().setTaskId(aTaskID).setAgentId(aAgentID)).build());
    }

    public void reconcile(List<Protos.Call.Reconcile.Task> aTasks) {
        this.mScheduler.sendCall(this.createCall(Protos.Call.Type.RECONCILE).setReconcile(Protos.Call.Reconcile.newBuilder().addAllTasks(aTasks).build()).build());
    }

    public void reconcileOperations(List<Protos.Call.ReconcileOperations.Operation> aOperations) {
        this.mScheduler.sendCall(this.createCall(Protos.Call.Type.RECONCILE_OPERATIONS).setReconcileOperations(Protos.Call.ReconcileOperations.newBuilder().addAllOperations(aOperations).build()).build());
    }

    public void revive() {
        this.revive(Collections.emptyList());
    }

    public void revive(List<String> aRoles) {
        this.mScheduler.sendCall(this.createCall(Protos.Call.Type.REVIVE).setRevive(Protos.Call.Revive.newBuilder().addAllRoles(aRoles).build()).build());
    }

    public void suppress() {
        this.suppress(Collections.emptyList());
    }

    public void suppress(List<String> aRoles) {
        this.mScheduler.sendCall(this.createCall(Protos.Call.Type.SUPPRESS).setSuppress(Protos.Call.Suppress.newBuilder().addAllRoles(aRoles).build()).build());
    }

    public void teardown() throws IOException {
        this.mScheduler.sendCall(this.mScheduler.createCall(Protos.Call.Type.TEARDOWN).build());
        this.mScheduler.close();
    }

    private Protos.Call.Builder createCall(Protos.Call.Type aType) {
        return this.mScheduler.createCall(aType);
    }
}

