/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.server;

import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.EntityRepository;
import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.Titled;
import au.com.mountainpass.hyperstate.core.entities.Entity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import au.com.mountainpass.hyperstate.server.serialization.mixins.LinkSerialisationMixin;
import au.com.mountainpass.hyperstate.server.serialization.mixins.TitledSerialisationMixin;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.HandlerMapping;

@RequestMapping(value={"/"}, produces={"application/vnd.siren+json", "application/json"})
public abstract class HyperstateController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EntityRepository repository;
    @Autowired
    ObjectMapper objectMapper;

    @PostConstruct
    public void postConstructed() {
        this.objectMapper.addMixIn(Link.class, LinkSerialisationMixin.class);
        this.objectMapper.addMixIn(Titled.class, TitledSerialisationMixin.class);
        this.objectMapper.findAndRegisterModules();
        this.onConstructed();
    }

    protected abstract void onConstructed();

    @RequestMapping(value={"**"}, method={RequestMethod.DELETE}, produces={"application/vnd.siren+json", "application/json"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    @Async
    public CompletableFuture<ResponseEntity<?>> delete(@RequestParam MultiValueMap<String, Object> allRequestParams, HttpServletRequest req) throws URISyntaxException, NoSuchMethodException, SecurityException, ScriptException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, ExecutionException {
        String url = (String)req.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        StringBuffer fullUrl = req.getRequestURL();
        String uri = req.getRequestURI();
        String ctx = req.getContextPath();
        String base = fullUrl.substring(0, fullUrl.length() - uri.length() + ctx.length());
        return this.getEntity(url).thenApplyAsync(entity -> this.deleteEntityAndRespond((EntityWrapper<?>)entity, allRequestParams, URI.create(base)));
    }

    private ResponseEntity<?> deleteEntityAndRespond(EntityWrapper<?> entity, MultiValueMap<String, Object> allRequestParams, URI location) {
        Action action;
        if (entity == null) {
            return ResponseEntity.noContent().build();
        }
        Object actionName = allRequestParams.getFirst((Object)"action");
        if (actionName == null) {
            actionName = "delete";
        }
        if ((action = entity.getAction(actionName.toString())) == null) {
            return ResponseEntity.badRequest().build();
        }
        try {
            CompletableFuture invocationResult = action.invoke(new HashMap());
            invocationResult.join();
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return ResponseEntity.noContent().location(location).build();
    }

    @RequestMapping(value={"**"}, method={RequestMethod.GET}, produces={"application/vnd.siren+json", "application/json"})
    @ResponseBody
    @Async
    public CompletableFuture<ResponseEntity<?>> get(@RequestParam Map<String, Object> allRequestParams, HttpServletRequest request) {
        CompletableFuture<EntityWrapper<?>> entityFuture = this.getEntity(allRequestParams, request);
        return entityFuture.thenApplyAsync(entity -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes());
            if (entity == null) {
                return ResponseEntity.notFound().build();
            }
            if (allRequestParams.containsKey("action")) {
                Action action = entity.getAction(allRequestParams.get("action").toString());
                if (action != null) {
                    return ResponseEntity.ok(action.invoke(allRequestParams).join());
                }
                throw new NotImplementedException("TODO");
            }
            return ResponseEntity.ok((Object)entity);
        });
    }

    private CompletableFuture<EntityWrapper<?>> getEntity(Map<String, Object> allRequestParams, HttpServletRequest request) {
        String url = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        CompletableFuture<EntityWrapper<?>> entityFuture = this.getEntity(url);
        return entityFuture;
    }

    protected CompletableFuture<EntityWrapper<?>> getEntity(String identifier) {
        return this.repository.findOne(identifier);
    }

    public CompletableFuture<EntityWrapper<?>> getRoot() {
        return this.getEntity(this.getRootPath());
    }

    private String getRootPath() {
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(this.getClass(), RequestMapping.class);
        return requestMapping.value()[0];
    }

    @RequestMapping(value={"**"}, method={RequestMethod.GET}, produces={"*/*"})
    @ResponseBody
    @Async
    public CompletableFuture<ResponseEntity<?>> getResource(@RequestParam Map<String, Object> allRequestParams, HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        CompletableFuture<EntityWrapper<?>> entityFuture = this.getEntity(allRequestParams, request);
        return entityFuture.thenApplyAsync(entity -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes());
            if (entity == null) {
                return this.getResource(path);
            }
            return this.getIndex(HttpStatus.OK);
        });
    }

    private ResponseEntity<?> getIndex(HttpStatus status) {
        InputStream inputStream = this.getClass().getResourceAsStream("/static/index.html");
        InputStreamResource inputStreamResource = new InputStreamResource(inputStream);
        return ResponseEntity.status((HttpStatus)status).body((Object)inputStreamResource);
    }

    private ResponseEntity<?> getResource(String path) {
        InputStream inputStream = this.getClass().getResourceAsStream("/static" + path.toString());
        if (inputStream == null) {
            String webjarPath = "/META-INF/resources" + path;
            inputStream = this.getClass().getResourceAsStream(webjarPath);
        }
        if (inputStream == null) {
            return this.getIndex(HttpStatus.NOT_FOUND);
        }
        InputStreamResource inputStreamResource = new InputStreamResource(inputStream);
        return ResponseEntity.ok((Object)inputStreamResource);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<?> onException(Exception e) {
        this.LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        return this.getIndex(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.POST}, produces={"application/vnd.siren+json", "application/json"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public CompletableFuture<ResponseEntity<?>> post(@RequestParam MultiValueMap<String, Object> allRequestParams, HttpServletRequest request) throws URISyntaxException, NoSuchMethodException, SecurityException, ScriptException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, ExecutionException {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        RequestAttributes currentRequestAttributes = RequestContextHolder.getRequestAttributes();
        RequestContextHolder.setRequestAttributes((RequestAttributes)currentRequestAttributes, (boolean)Boolean.TRUE);
        return this.getEntity(path).thenApply(entity -> {
            if (entity == null) {
                return ResponseEntity.notFound().build();
            }
            Object actionName = allRequestParams.getFirst((Object)"action");
            if (actionName == null) {
                return ResponseEntity.badRequest().build();
            }
            Action action = entity.getAction(actionName.toString());
            if (action == null) {
                return ResponseEntity.badRequest().build();
            }
            CompletableFuture futureResult = action.invoke(allRequestParams.toSingleValueMap());
            return ResponseEntity.created((URI)((Entity)futureResult.join()).getAddress().getHref()).build();
        });
    }

    @RequestMapping(value={"**"}, method={RequestMethod.PUT}, produces={"application/vnd.siren+json", "application/json"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public ResponseEntity<?> put(@RequestParam MultiValueMap<String, Object> queryParams, HttpServletRequest request) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, URISyntaxException, InterruptedException, ExecutionException {
        String url = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        EntityWrapper<?> entity = this.getEntity(url).get();
        if (entity == null) {
            return ResponseEntity.notFound().build();
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.putAll(queryParams);
        String actionName = (String)queryParams.getFirst((Object)"action");
        if (actionName == null) {
            return ResponseEntity.badRequest().build();
        }
        Action action = entity.getAction(actionName);
        if (action == null) {
            return ResponseEntity.badRequest().build();
        }
        action.invoke(params.toSingleValueMap());
        return ResponseEntity.noContent().build();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

