/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core.entities;

import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.Address;
import au.com.mountainpass.hyperstate.core.EntityRelationship;
import au.com.mountainpass.hyperstate.core.EntityRepository;
import au.com.mountainpass.hyperstate.core.JavaAction;
import au.com.mountainpass.hyperstate.core.JavaAddress;
import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.NavigationalRelationship;
import au.com.mountainpass.hyperstate.core.Parameter;
import au.com.mountainpass.hyperstate.core.entities.Entity;
import au.com.mountainpass.hyperstate.core.entities.LinkedEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;

@JsonPropertyOrder(value={"class", "properties", "entities", "actions", "links", "title"})
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class EntityWrapper<T>
extends Entity {
    private static final int PAGE_SIZE = 10;
    private Map<String, Action<?>> actions = new HashMap();
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @JsonProperty(value="links")
    private Set<NavigationalRelationship> navigationalRelationships = new HashSet<NavigationalRelationship>();
    private String path;
    T properties;
    private EntityRepository repository;
    private Set<EntityRelationship> entityRelationships = new HashSet<EntityRelationship>();

    protected EntityWrapper(EntityRepository repository, String path, T properties, String title, String ... classes) {
        super(title, classes);
        Method[] methods;
        this.repository = repository;
        this.properties = properties;
        this.path = path;
        this.add(new NavigationalRelationship(new Link(new JavaAddress(repository, this), title, new String[0]), "self"));
        block6: for (Method method : methods = this.getClass().getMethods()) {
            HttpMethod httpMethod = JavaAction.determineMethodNature(method);
            boolean formTypes = Parameter.hasFormTypes(method);
            if (!formTypes || httpMethod == null) continue;
            switch (httpMethod) {
                case DELETE: {
                    this.actions.put(method.getName(), new JavaAction(repository, this, method));
                    continue block6;
                }
                case POST: {
                    this.actions.put(method.getName(), new JavaAction(repository, this, method));
                    continue block6;
                }
                case PUT: {
                    this.actions.put(method.getName(), new JavaAction(repository, this, method));
                    continue block6;
                }
                case GET: {
                    this.actions.put(method.getName(), new JavaAction(repository, this, method));
                    continue block6;
                }
            }
        }
    }

    protected EntityWrapper(@JsonProperty(value="properties") T properties) {
        this.properties = properties;
    }

    public void add(NavigationalRelationship navigationalRelationship) {
        this.navigationalRelationships.add(navigationalRelationship);
    }

    public Action<?> getAction(String name) {
        return this.actions.get(name);
    }

    @JsonProperty(value="actions")
    public ImmutableSet<Action<?>> getActions() {
        return ImmutableSet.copyOf(this.actions.values());
    }

    @JsonProperty(value="entities")
    public ImmutableSet<EntityRelationship> getEntities() {
        return ImmutableSet.copyOf(this.entityRelationships);
    }

    public Link getLink(String rel) {
        Optional<NavigationalRelationship> link = this.getLinks().stream().filter(l -> l.hasRelationship(rel)).findAny();
        if (link.isPresent()) {
            return link.get().getLink();
        }
        return null;
    }

    public ImmutableSet<NavigationalRelationship> getLinks() {
        return ImmutableSet.copyOf(this.navigationalRelationships);
    }

    public T getProperties() {
        return this.properties;
    }

    public <K, L extends EntityWrapper<K>> L reload(Class<L> type) {
        return (L)this;
    }

    public <L extends EntityWrapper<?>> CompletableFuture<L> resolve(Class<L> type) {
        return CompletableFuture.supplyAsync(() -> this);
    }

    public <K, L extends EntityWrapper<K>> L resolve(ParameterizedTypeReference<L> type) {
        return (L)this;
    }

    public void setActions(Action<?>[] actions) {
        for (Action<?> action : actions) {
            this.actions.put(action.getName(), action);
        }
    }

    public void setEntities(EntityRelationship[] entities) {
        for (EntityRelationship entity : entities) {
            this.entityRelationships.add(entity);
        }
    }

    public CompletableFuture<EntityWrapper<T>> addEntity(EntityRelationship entityRelationship) {
        this.entityRelationships.add(entityRelationship);
        return this.repository.save(this);
    }

    @Override
    public LinkedEntity toLinkedEntity() {
        LinkedEntity linkedEntity = new LinkedEntity(this.getLink("self"), this.getTitle(), this.getClasses());
        return linkedEntity;
    }

    @Override
    @JsonIgnore
    public Address getAddress() {
        return new JavaAddress(this.repository, this);
    }

    @JsonIgnore
    public String getPath() {
        return this.path;
    }

    @JsonIgnore
    public EntityRepository getRepository() {
        return this.repository;
    }

    @JsonIgnore
    public String getId() {
        return this.path;
    }
}

