/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.client;

import au.com.mountainpass.hyperstate.core.EntityRepository;
import au.com.mountainpass.hyperstate.core.JavaAddress;
import au.com.mountainpass.hyperstate.core.Resolver;
import au.com.mountainpass.hyperstate.core.entities.DeletedEntity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import au.com.mountainpass.hyperstate.exceptions.EntityNotFoundException;
import java.util.concurrent.CompletableFuture;
import org.springframework.core.ParameterizedTypeReference;

public class RepositoryResolver
implements Resolver {
    private EntityRepository repository;

    public RepositoryResolver(EntityRepository repository) {
        this.repository = repository;
    }

    public <T> CompletableFuture<T> get(JavaAddress address, Class<T> type) {
        return this.get(address).thenApply(entity -> entity);
    }

    public <T> CompletableFuture<T> get(JavaAddress address, ParameterizedTypeReference<T> type) {
        return this.get(address).thenApply(entity -> entity);
    }

    public CompletableFuture<EntityWrapper<?>> get(JavaAddress address) {
        return this.repository.findOne(address.getPath()).thenApply(entity -> {
            if (entity == null) {
                throw new EntityNotFoundException();
            }
            return entity;
        });
    }

    @Override
    public <E extends EntityWrapper<?>> CompletableFuture<E> get(String path, Class<E> type) {
        return this.repository.findOne(path).thenApply(entity -> {
            if (entity == null) {
                throw new EntityNotFoundException();
            }
            return entity;
        });
    }

    public EntityRepository getEntityRepository() {
        return this.repository;
    }

    public CompletableFuture<DeletedEntity> delete(EntityWrapper<?> entity) {
        return this.repository.delete(entity);
    }
}

