/*
 * Decompiled with CFR 0.152.
 */
package au.com.gridstone.rxstore.converters;

import au.com.gridstone.rxstore.Converter;
import au.com.gridstone.rxstore.ConverterException;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class MoshiConverter
implements Converter {
    private final Moshi moshi;

    public MoshiConverter() {
        this(new Moshi.Builder().build());
    }

    public MoshiConverter(Moshi moshi) {
        this.moshi = moshi;
    }

    public <T> void write(T data, Type type, File file) throws ConverterException {
        try {
            JsonAdapter adapter = this.moshi.adapter(type);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
            adapter.toJson(sink, data);
            sink.close();
        }
        catch (IOException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public <T> T read(File file, Type type) {
        try {
            JsonAdapter adapter = this.moshi.adapter(type);
            BufferedSource source = Okio.buffer((Source)Okio.source((File)file));
            Object value = source.exhausted() ? null : adapter.nullSafe().fromJson(source);
            source.close();
            return (T)value;
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

