/*
 * Decompiled with CFR 0.152.
 */
package au.com.gridstone.rxstore.converters;

import au.com.gridstone.rxstore.Converter;
import au.com.gridstone.rxstore.ConverterException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public class JacksonConverter
implements Converter {
    private final ObjectMapper objectMapper;

    public JacksonConverter() {
        this(new ObjectMapper());
    }

    public JacksonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> void write(T data, Type type, File file) throws ConverterException {
        try {
            this.objectMapper.writeValue(file, data);
        }
        catch (IOException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public <T> T read(File file, Type type) throws ConverterException {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
        try {
            FileReader reader = new FileReader(file);
            Object value = !((Reader)reader).ready() ? null : this.objectMapper.readValue((Reader)reader, javaType);
            ((Reader)reader).close();
            return (T)value;
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

