/*
 * Decompiled with CFR 0.152.
 */
package au.com.gridstone.grex;

import android.content.Context;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public class GRexPersister {
    private final Context context;
    private final Gson gson;
    private final String dirName;

    public GRexPersister(Context context, String dirName) {
        this(context, dirName, new Gson());
    }

    public GRexPersister(Context context, String dirName, Gson gson) {
        this.context = context.getApplicationContext();
        this.gson = gson;
        this.dirName = dirName;
    }

    public <T> Observable<List<T>> putList(final String key, final List<T> list, final Class<T> type) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Subscriber<? super List<T>> subscriber) {
                ListOfSomething listType = new ListOfSomething(type);
                Writer writer = null;
                try {
                    File outFile = GRexPersister.this.getFile(key);
                    writer = new FileWriter(outFile);
                    GRexPersister.this.gson.toJson((Object)list, listType, (Appendable)writer);
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onNext((Object)list);
                        subscriber.onCompleted();
                    }
                }
                catch (IOException e) {
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onError((Throwable)e);
                    }
                }
                finally {
                    block15: {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException e) {
                            if (subscriber.isUnsubscribed()) break block15;
                            subscriber.onError((Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public <T> Observable<List<T>> getList(final String key, final Class<T> type) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Subscriber<? super List<T>> subscriber) {
                ListOfSomething listType = new ListOfSomething(type);
                Reader reader = null;
                try {
                    File inFile = GRexPersister.this.getFile(key);
                    if (!inFile.exists()) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext(Collections.emptyList());
                            subscriber.onCompleted();
                        }
                        return;
                    }
                    reader = new FileReader(inFile);
                    List result = (List)GRexPersister.this.gson.fromJson(reader, listType);
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onNext((Object)result);
                        subscriber.onCompleted();
                    }
                }
                catch (Exception e) {
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onError((Throwable)e);
                    }
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException ignored) {}
                }
            }
        });
    }

    public <T> Observable<List<T>> addToList(final String key, final T object, final Class<T> type) {
        return this.getList(key, type).map(new Func1<List<T>, List<T>>(){

            public List<T> call(List<T> list) {
                list = new ArrayList(list);
                list.add(object);
                return list;
            }
        }).flatMap(new Func1<List<T>, Observable<List<T>>>(){

            public Observable<List<T>> call(List<T> list) {
                return GRexPersister.this.putList(key, list, type);
            }
        });
    }

    public <T> Observable<List<T>> removeFromList(final String key, final T object, final Class<T> type) {
        return this.getList(key, type).map(new Func1<List<T>, List<T>>(){

            public List<T> call(List<T> list) {
                list = new ArrayList(list);
                list.remove(object);
                return list;
            }
        }).flatMap(new Func1<List<T>, Observable<List<T>>>(){

            public Observable<List<T>> call(List<T> list) {
                return GRexPersister.this.putList(key, list, type);
            }
        });
    }

    public <T> Observable<List<T>> removeFromList(final String key, final int position, final Class<T> type) {
        return this.getList(key, type).map(new Func1<List<T>, List<T>>(){

            public List<T> call(List<T> list) {
                list = new ArrayList(list);
                list.remove(position);
                return list;
            }
        }).flatMap(new Func1<List<T>, Observable<List<T>>>(){

            public Observable<List<T>> call(List<T> list) {
                return GRexPersister.this.putList(key, list, type);
            }
        });
    }

    public <T> Observable<T> put(final String key, final T object) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Subscriber<? super T> subscriber) {
                Writer writer = null;
                try {
                    File outFile = GRexPersister.this.getFile(key);
                    writer = new FileWriter(outFile);
                    GRexPersister.this.gson.toJson(object, (Appendable)writer);
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onNext(object);
                        subscriber.onCompleted();
                    }
                }
                catch (Exception e) {
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onError((Throwable)e);
                    }
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    public <T> Observable<T> get(final String key, final Class<T> type) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Subscriber<? super T> subscriber) {
                Reader reader = null;
                try {
                    File inFile = GRexPersister.this.getFile(key);
                    if (!inFile.exists()) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext(null);
                            subscriber.onCompleted();
                        }
                        return;
                    }
                    reader = new FileReader(inFile);
                    Object result = GRexPersister.this.gson.fromJson(reader, type);
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onNext(result);
                        subscriber.onCompleted();
                    }
                }
                catch (Exception e) {
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onError((Throwable)e);
                    }
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    public Observable<Boolean> clear(final String key) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

            public void call(Subscriber<? super Boolean> subscriber) {
                File file = GRexPersister.this.getFile(key);
                boolean result = file.delete();
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)result);
                    subscriber.onCompleted();
                }
            }
        });
    }

    private File getFile(String key) {
        return new File(this.context.getDir(this.dirName, 0), key);
    }

    private static class ListOfSomething<T>
    implements ParameterizedType {
        private final Class<?> wrappedType;

        public ListOfSomething(Class<T> wrappedType) {
            this.wrappedType = wrappedType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.wrappedType};
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return List.class;
        }
    }
}

