/*
 * Decompiled with CFR 0.152.
 */
package au.com.gridstone.grex.converters;

import au.com.gridstone.grex.converter.Converter;
import au.com.gridstone.grex.converter.ConverterException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;

public class JacksonConverter
implements Converter {
    private ObjectMapper objectMapper;

    public JacksonConverter() {
        this(new ObjectMapper());
    }

    public JacksonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> void write(T data, Writer writer) throws ConverterException {
        try {
            this.objectMapper.writeValue(writer, data);
        }
        catch (IOException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public <T> T read(Reader reader, Type type) throws ConverterException {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
        try {
            return (T)this.objectMapper.readValue(reader, javaType);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

