/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.pactbroker;

import au.com.dius.pact.pactbroker.BiFunction;
import au.com.dius.pact.pactbroker.HalClientBase;
import au.com.dius.pact.pactbroker.IHalClient;
import au.com.dius.pact.pactbroker.InvalidHalResponse;
import au.com.dius.pact.pactbroker.InvalidNavigationRequest;
import au.com.dius.pact.pactbroker.NotFoundHalResponse;
import au.com.dius.pact.pactbroker.RequestFailedException;
import au.com.dius.pact.provider.broker.com.github.kittinunf.result.Result;
import com.github.salomonbrys.kotson.ElementKt;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 I2\u00020\u0001:\u0001IB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\"H\u0007J4\u0010#\u001a\n $*\u0004\u0018\u00010\u00030\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0016J$\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J*\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\u0019\u0012\b\u0012\u00060-j\u0002`.0,2\u0006\u0010(\u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\"H\u0002J6\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u00032\u001a\u00103\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000604J\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0003H\u0016J$\u0010:\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010*\u001a\u00020\u0003H\u0016J\"\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005J(\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\b\u0012\u00060-j\u0002`.0,2\u0006\u0010 \u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0016Jb\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\b\u0012\u00060-j\u0002`.0,2\u0006\u0010 \u001a\u00020\u00032\u0006\u00102\u001a\u00020\u000328\u0010>\u001a4\u0012\u0013\u0012\u00110@\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(C\u0012\u0013\u0012\u00110D\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(E\u0012\u0004\u0012\u00020\"\u0018\u00010?H\u0016J\b\u0010F\u001a\u00020\u000bH\u0016J\u001a\u0010G\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u0003H\u0016J8\u0010G\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u00032\u001c\u00103\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u000104H\u0016J@\u0010G\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u00032\u001c\u00103\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u0001042\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u0013R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006J"}, d2={"Lau/com/dius/pact/pactbroker/HalClientBase;", "Lau/com/dius/pact/pactbroker/IHalClient;", "baseUrl", "", "options", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "getHttpClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "setHttpClient", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "lastUrl", "getLastUrl", "setLastUrl", "(Ljava/lang/String;)V", "getOptions", "()Ljava/util/Map;", "setOptions", "(Ljava/util/Map;)V", "pathInfo", "Lcom/google/gson/JsonElement;", "getPathInfo", "()Lcom/google/gson/JsonElement;", "setPathInfo", "(Lcom/google/gson/JsonElement;)V", "buildUrl", "Ljava/net/URI;", "url", "encodePath", "", "encodePathParameter", "kotlin.jvm.PlatformType", "key", "value", "fetch", "path", "fetchLink", "link", "getJson", "Lau/com/dius/pact/provider/broker/com/github/kittinunf/result/Result;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleFailure", "resp", "Lorg/apache/http/HttpResponse;", "body", "closure", "Lau/com/dius/pact/pactbroker/BiFunction;", "initPathInfo", "", "isJsonResponse", "contentType", "Lorg/apache/http/entity/ContentType;", "navigate", "parseLinkUrl", "href", "postJson", "handler", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "status", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "response", "setupHttpClient", "uploadJson", "bodyJson", "Companion", "pact-jvm-pact-broker"})
public abstract class HalClientBase
implements IHalClient {
    @Nullable
    private CloseableHttpClient httpClient;
    @Nullable
    private JsonElement pathInfo;
    @Nullable
    private String lastUrl;
    @NotNull
    private final String baseUrl;
    @NotNull
    private Map<String, ? extends Object> options;
    @NotNull
    public static final String ROOT = "/";
    @NotNull
    private static final Regex URL_TEMPLATE_REGEX;
    @NotNull
    private static final Regex URL_REGEX;
    public static final Companion Companion;

    @Nullable
    public final CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public final void setHttpClient(@Nullable CloseableHttpClient closeableHttpClient) {
        this.httpClient = closeableHttpClient;
    }

    @Nullable
    public final JsonElement getPathInfo() {
        return this.pathInfo;
    }

    public final void setPathInfo(@Nullable JsonElement jsonElement) {
        this.pathInfo = jsonElement;
    }

    @Nullable
    public final String getLastUrl() {
        return this.lastUrl;
    }

    public final void setLastUrl(@Nullable String string) {
        this.lastUrl = string;
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        return this.postJson(url, body, null);
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body, @Nullable Function2<? super Integer, ? super CloseableHttpResponse, Boolean> handler) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        CloseableHttpClient client = this.setupHttpClient();
        return Result.Companion.of((Function0)new Function0<Boolean>(url, body, client, handler){
            final /* synthetic */ String $url;
            final /* synthetic */ String $body;
            final /* synthetic */ CloseableHttpClient $client;
            final /* synthetic */ Function2 $handler;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean invoke() {
                Closeable closeable;
                boolean bl;
                HttpPost httpPost = new HttpPost(this.$url);
                httpPost.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
                httpPost.setEntity((HttpEntity)new StringEntity(this.$body, ContentType.APPLICATION_JSON));
                Closeable closeable2 = (Closeable)this.$client.execute((HttpUriRequest)httpPost);
                boolean bl2 = false;
                try {
                    boolean bl3;
                    CloseableHttpResponse it = (CloseableHttpResponse)closeable2;
                    if (this.$handler != null) {
                        Integer n = it.getStatusLine().getStatusCode();
                        CloseableHttpResponse closeableHttpResponse = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                        bl3 = (Boolean)this.$handler.invoke((Object)n, (Object)closeableHttpResponse);
                    } else {
                        bl3 = it.getStatusLine().getStatusCode() < 300;
                    }
                    bl = bl3;
                    closeable = closeable2;
                }
                catch (Exception exception) {
                    try {
                        bl2 = true;
                        try {
                            Closeable closeable3 = closeable2;
                            if (closeable3 != null) {
                                closeable3.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw (Throwable)exception;
                    }
                    catch (Throwable throwable) {
                        if (!bl2) {
                            Closeable closeable4 = closeable2;
                            if (closeable4 != null) {
                                closeable4.close();
                            }
                        }
                        throw throwable;
                    }
                }
                if (closeable != null) {
                    closeable.close();
                }
                return bl;
            }
            {
                this.$url = string;
                this.$body = string2;
                this.$client = closeableHttpClient;
                this.$handler = function2;
                super(0);
            }
        });
    }

    @NotNull
    public CloseableHttpClient setupHttpClient() {
        if (this.httpClient == null) {
            HttpClientBuilder builder = HttpClients.custom().useSystemProperties();
            if (this.options.get("authentication") instanceof List) {
                String scheme;
                String string;
                Object object = this.options.get("authentication");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                }
                List authentication = (List)object;
                String string2 = string = String.valueOf(CollectionsKt.first((List)authentication));
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                string = scheme = string3;
                switch (string.hashCode()) {
                    case 93508654: {
                        if (string.equals("basic")) {
                            if (authentication.size() > 2) {
                                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                                URI uri = new URI(this.baseUrl);
                                credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(String.valueOf(authentication.get(1)), String.valueOf(authentication.get(2))));
                                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                                break;
                            }
                            Companion.getLogger().warn((Function0)setupHttpClient.1.INSTANCE);
                            break;
                        }
                    }
                    default: {
                        Companion.getLogger().warn((Function0)new Function0<String>(scheme){
                            final /* synthetic */ String $scheme;

                            @NotNull
                            public final String invoke() {
                                return "Hal client Only supports basic authentication, got '" + this.$scheme + "', ignoring.";
                            }
                            {
                                this.$scheme = string;
                                super(0);
                            }
                        });
                    }
                }
            } else if (this.options.containsKey("authentication")) {
                Companion.getLogger().warn((Function0)setupHttpClient.3.INSTANCE);
            }
            this.httpClient = builder.build();
        }
        CloseableHttpClient closeableHttpClient = this.httpClient;
        if (closeableHttpClient == null) {
            Intrinsics.throwNpe();
        }
        return closeableHttpClient;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull Map<String, ? extends Object> options, @NotNull String link) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            jsonElement = this.fetch(ROOT);
        }
        this.pathInfo = jsonElement;
        this.pathInfo = this.fetchLink(link, options);
        return this;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull String link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        HalClientBase halClientBase = this;
        Map map = MapsKt.emptyMap();
        return halClientBase.navigate(map, link);
    }

    @Override
    @NotNull
    public JsonElement fetch(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.fetch(path, true);
    }

    @Override
    @NotNull
    public JsonElement fetch(@NotNull String path, boolean encodePath) {
        Result<JsonElement, Exception> response;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.lastUrl = path;
        Companion.getLogger().debug((Function0)new Function0<String>(path){
            final /* synthetic */ String $path;

            @NotNull
            public final String invoke() {
                return "Fetching: " + this.$path;
            }
            {
                this.$path = string;
                super(0);
            }
        });
        Result<JsonElement, Exception> result = response = this.getJson(path, encodePath);
        if (result instanceof Result.Success) {
            return (JsonElement)((Result.Success)response).getValue();
        }
        if (result instanceof Result.Failure) {
            throw (Throwable)((Result.Failure)response).getError();
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Result<JsonElement, Exception> getJson(String path, boolean encodePath) {
        this.setupHttpClient();
        return Result.Companion.of((Function0)new Function0<JsonElement>(this, path, encodePath){
            final /* synthetic */ HalClientBase this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ boolean $encodePath;

            public final JsonElement invoke() {
                CloseableHttpResponse response;
                HttpGet httpGet = new HttpGet(this.this$0.buildUrl(this.$path, this.$encodePath));
                httpGet.addHeader("Content-Type", "application/json");
                httpGet.addHeader("Accept", "application/hal+json, application/json");
                CloseableHttpClient closeableHttpClient = this.this$0.getHttpClient();
                if (closeableHttpClient == null) {
                    Intrinsics.throwNpe();
                }
                if ((response = closeableHttpClient.execute((HttpUriRequest)httpGet)).getStatusLine().getStatusCode() < 300) {
                    ContentType contentType;
                    ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
                    if (HalClientBase.access$isJsonResponse(this.this$0, contentType2)) {
                        return new JsonParser().parse(EntityUtils.toString((HttpEntity)response.getEntity()));
                    }
                    throw (Throwable)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got '" + contentType + '\'');
                }
                switch (response.getStatusLine().getStatusCode()) {
                    case 404: {
                        throw (Throwable)new NotFoundHalResponse("No HAL document found at path '" + this.$path + '\'');
                    }
                }
                throw (Throwable)new RequestFailedException("Request to path '" + this.$path + "' failed with response '" + response.getStatusLine() + '\'');
            }
            {
                this.this$0 = halClientBase;
                this.$path = string;
                this.$encodePath = bl;
                super(0);
            }
        });
    }

    static /* bridge */ /* synthetic */ Result getJson$default(HalClientBase halClientBase, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getJson");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return halClientBase.getJson(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final URI buildUrl(@NotNull String url, boolean encodePath) {
        URI uRI;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        MatchResult match = Companion.getURL_REGEX().matchEntire((CharSequence)url);
        if (match != null) {
            void port;
            void host;
            void scheme;
            MatchResult.Destructured destructured = match.getDestructured();
            Object object = destructured;
            String string = (String)object.getMatch().getGroupValues().get(1);
            object = destructured;
            String string2 = (String)object.getMatch().getGroupValues().get(2);
            object = destructured;
            String string3 = (String)object.getMatch().getGroupValues().get(3);
            object = destructured;
            String path = (String)object.getMatch().getGroupValues().get(4);
            URIBuilder builder = new URIBuilder().setScheme((String)scheme).setHost((String)host);
            object = (CharSequence)port;
            if (object.length() > 0) {
                object = port;
                int n = 1;
                URIBuilder uRIBuilder = builder;
                Object object2 = object;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = ((String)object2).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                String string5 = string4;
                object = string5;
                int n2 = Integer.parseInt((String)object);
                uRIBuilder.setPort(n2);
            }
            URI uRI2 = encodePath ? builder.setPath(path).build() : new URI(builder.build().toString() + path);
            uRI = uRI2;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"if (encodePath) {\n      \u2026oString() + path)\n      }");
        } else {
            URI uRI3 = encodePath ? new URIBuilder(this.baseUrl).setPath(url).build() : new URI(this.baseUrl + url);
            uRI = uRI3;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI3, (String)"if (encodePath) {\n      \u2026RI(baseUrl + url)\n      }");
        }
        return uRI;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ URI buildUrl$default(HalClientBase halClientBase, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildUrl");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return halClientBase.buildUrl(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final URI buildUrl(@NotNull String url) {
        return HalClientBase.buildUrl$default(this, url, false, 2, null);
    }

    private final boolean isJsonResponse(ContentType contentType) {
        return Intrinsics.areEqual((Object)contentType.getMimeType(), (Object)"application/json") || Intrinsics.areEqual((Object)contentType.getMimeType(), (Object)"application/hal+json");
    }

    private final JsonElement fetchLink(String link, Map<String, ? extends Object> options) {
        JsonElement links;
        JsonElement jsonElement = this.pathInfo;
        if ((jsonElement != null && (jsonElement = ElementKt.getNullObj((JsonElement)jsonElement)) != null ? jsonElement.get("_links") : null) == null) {
            throw (Throwable)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got " + "a response with no '_links'. URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
        }
        JsonElement jsonElement2 = this.pathInfo;
        if (jsonElement2 == null) {
            Intrinsics.throwNpe();
        }
        if ((links = ElementKt.get((JsonElement)jsonElement2, (String)"_links")).isJsonObject()) {
            if (!ElementKt.getObj((JsonElement)links).has(link)) {
                throw (Throwable)new InvalidHalResponse("Link '" + link + "' was not found in the response, only the following links where " + "found: " + ElementKt.keys((JsonObject)ElementKt.getObj((JsonElement)links)) + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
            }
            JsonElement linkData = ElementKt.get((JsonElement)links, (String)link);
            if (linkData.isJsonArray()) {
                if (options.containsKey("name")) {
                    JsonElement jsonElement3;
                    Object v2;
                    block12: {
                        Iterable iterable;
                        Iterable iterable2 = iterable = (Iterable)linkData.getAsJsonArray();
                        for (Object t : iterable2) {
                            JsonElement it = (JsonElement)t;
                            if (!(it.isJsonObject() && Intrinsics.areEqual((Object)ElementKt.get((JsonElement)it, (String)"name"), (Object)options.get("name")))) continue;
                            v2 = t;
                            break block12;
                        }
                        v2 = null;
                    }
                    JsonElement linkByName = v2;
                    if (linkByName != null && linkByName.isJsonObject() && ElementKt.get((JsonElement)linkByName, (String)"templated").isJsonPrimitive() && ElementKt.getBool((JsonElement)ElementKt.get((JsonElement)linkByName, (String)"templated"))) {
                        String string = ElementKt.get((JsonElement)linkByName, (String)"href").toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"linkByName[\"href\"].toString()");
                        jsonElement3 = this.fetch(this.parseLinkUrl(string, options), false);
                    } else if (linkByName != null && linkByName.isJsonObject()) {
                        jsonElement3 = this.fetch(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkByName, (String)"href")));
                    } else {
                        throw (Throwable)new InvalidNavigationRequest("Link '" + link + "' does not have an entry with name '" + options.get("name") + "'. " + "URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
                    }
                    return jsonElement3;
                }
                throw (Throwable)new InvalidNavigationRequest("Link '" + link + "' has multiple entries. You need to filter by the link name. " + "URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
            }
            if (linkData.isJsonObject()) {
                return ElementKt.getObj((JsonElement)linkData).has("templated") && ElementKt.get((JsonElement)linkData, (String)"templated").isJsonPrimitive() && ElementKt.getBool((JsonElement)ElementKt.get((JsonElement)linkData, (String)"templated")) ? this.fetch(this.parseLinkUrl(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkData, (String)"href")), options), false) : this.fetch(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkData, (String)"href")));
            }
            throw (Throwable)new InvalidHalResponse("Expected link in map form in the response, but " + "found: " + linkData + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
        }
        throw (Throwable)new InvalidHalResponse("Expected a map of links in the response, but " + "found: " + links + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
    }

    @NotNull
    public final String parseLinkUrl(@NotNull String href, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)href, (String)"href");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        String result = "";
        MatchResult match = Regex.find$default((Regex)Companion.getURL_TEMPLATE_REGEX(), (CharSequence)href, (int)0, (int)2, null);
        int index = 0;
        while (match != null) {
            MatchResult.Destructured destructured;
            int start = match.getRange().getStart() - 1;
            if (start >= index) {
                int n = index;
                result = result + StringsKt.substring((String)href, (IntRange)new IntRange(n, start));
            }
            index = match.getRange().getEndInclusive() + 1;
            MatchResult.Destructured destructured2 = destructured = match.getDestructured();
            String key = (String)destructured2.getMatch().getGroupValues().get(1);
            result = result + this.encodePathParameter(options, key, match.getValue());
            match = Companion.getURL_TEMPLATE_REGEX().find((CharSequence)href, index);
        }
        if (index < href.length()) {
            String string = href;
            StringBuilder stringBuilder = new StringBuilder().append(result);
            String string2 = string.substring(index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String string3 = string2;
            result = stringBuilder.append(string3).toString();
        }
        return result;
    }

    private final String encodePathParameter(Map<String, ? extends Object> options, String key, String value) {
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        Object object = options.get(key);
        if (object == null || (object = object.toString()) == null) {
            object = value;
        }
        return escaper.escape((String)object);
    }

    public final void initPathInfo() {
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            jsonElement = this.fetch(ROOT);
        }
        this.pathInfo = jsonElement;
    }

    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        return this.uploadJson(path, bodyJson, null, true);
    }

    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson, @Nullable BiFunction<String, String, Object> closure) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        return this.uploadJson(path, bodyJson, closure, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson, @Nullable BiFunction<String, String, Object> closure, boolean encodePath) {
        Closeable closeable;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        CloseableHttpClient client = this.setupHttpClient();
        HttpPut httpPut = new HttpPut(this.buildUrl(path, encodePath));
        httpPut.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        httpPut.setEntity((HttpEntity)new StringEntity(bodyJson, ContentType.APPLICATION_JSON));
        Closeable closeable2 = (Closeable)client.execute((HttpUriRequest)httpPut);
        boolean bl = false;
        try {
            String body;
            int n;
            Closeable closeable3;
            Charset charset;
            InputStream inputStream;
            Object object2;
            CloseableHttpResponse it = (CloseableHttpResponse)closeable2;
            if (it.getStatusLine().getStatusCode() < 300) {
                EntityUtils.consume((HttpEntity)it.getEntity());
                BiFunction<String, String, Object> biFunction = closure;
                object2 = biFunction != null ? biFunction.apply("OK", it.getStatusLine().toString()) : null;
            } else if (it.getStatusLine().getStatusCode() == 409) {
                inputStream = it.getEntity().getContent();
                charset = Charsets.UTF_8;
                closeable3 = inputStream;
                closeable3 = new InputStreamReader((InputStream)closeable3, charset);
                n = 8192;
                body = TextStreamsKt.readText((Reader)(closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n)));
                BiFunction<String, String, Object> biFunction = closure;
                object2 = biFunction != null ? biFunction.apply("FAILED", "" + it.getStatusLine().getStatusCode() + ' ' + it.getStatusLine().getReasonPhrase() + " - " + body) : null;
            } else if (closure != null) {
                inputStream = it.getEntity().getContent();
                charset = Charsets.UTF_8;
                closeable3 = inputStream;
                closeable3 = new InputStreamReader((InputStream)closeable3, charset);
                n = 8192;
                body = TextStreamsKt.readText((Reader)(closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n)));
                CloseableHttpResponse closeableHttpResponse = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                object2 = this.handleFailure((HttpResponse)closeableHttpResponse, body, closure);
            } else {
                object2 = null;
            }
            object = object2;
            closeable = closeable2;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Closeable closeable4 = closeable2;
                    if (closeable4 != null) {
                        closeable4.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                block15: {
                    if (bl) break block15;
                    Closeable closeable5 = closeable2;
                    if (closeable5 != null) {
                        closeable5.close();
                    }
                }
                throw throwable;
            }
        }
        if (closeable != null) {
            closeable.close();
        }
        return object;
    }

    @Nullable
    public final Object handleFailure(@NotNull HttpResponse resp, @Nullable String body, @NotNull BiFunction<String, String, Object> closure) {
        Intrinsics.checkParameterIsNotNull((Object)resp, (String)"resp");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        if (resp.getEntity().getContentType() != null) {
            ContentType contentType;
            ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)resp.getEntity());
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
            if (this.isJsonResponse(contentType2)) {
                JsonElement jsonBody;
                String error = "Unknown error";
                if (body != null && (jsonBody = new JsonParser().parse(body)) != null && ElementKt.getObj((JsonElement)jsonBody).has("errors")) {
                    if (ElementKt.get((JsonElement)jsonBody, (String)"errors").isJsonArray()) {
                        error = CollectionsKt.joinToString$default((Iterable)((Iterable)ElementKt.get((JsonElement)jsonBody, (String)"errors").getAsJsonArray()), (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.1.INSTANCE, (int)30, null);
                    } else if (ElementKt.get((JsonElement)jsonBody, (String)"errors").isJsonObject()) {
                        error = CollectionsKt.joinToString$default((Iterable)ElementKt.get((JsonElement)jsonBody, (String)"errors").getAsJsonObject().entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.2.INSTANCE, (int)30, null);
                    }
                }
                return closure.apply("FAILED", "" + resp.getStatusLine().getStatusCode() + ' ' + resp.getStatusLine().getReasonPhrase() + " - " + error);
            }
            return closure.apply("FAILED", "" + resp.getStatusLine().getStatusCode() + ' ' + resp.getStatusLine().getReasonPhrase() + " - " + body);
        }
        return closure.apply("FAILED", "" + resp.getStatusLine().getStatusCode() + ' ' + resp.getStatusLine().getReasonPhrase() + " - " + body);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final Map<String, Object> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.options = map;
    }

    @JvmOverloads
    public HalClientBase(@NotNull String baseUrl, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        this.baseUrl = baseUrl;
        this.options = options;
    }

    @JvmOverloads
    public /* synthetic */ HalClientBase(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, map);
    }

    @JvmOverloads
    public HalClientBase(@NotNull String baseUrl) {
        this(baseUrl, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        URL_TEMPLATE_REGEX = new Regex("\\{(\\w+)\\}");
        URL_REGEX = new Regex("([^:]+):\\/\\/([^\\/:]+)(:\\d+)?(.*)");
    }

    public static final /* synthetic */ boolean access$isJsonResponse(HalClientBase $this, @NotNull ContentType contentType) {
        return $this.isJsonResponse(contentType);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lau/com/dius/pact/pactbroker/HalClientBase$Companion;", "Lmu/KLogging;", "()V", "ROOT", "", "URL_REGEX", "Lkotlin/text/Regex;", "getURL_REGEX", "()Lkotlin/text/Regex;", "URL_TEMPLATE_REGEX", "getURL_TEMPLATE_REGEX", "pact-jvm-pact-broker"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final Regex getURL_TEMPLATE_REGEX() {
            return URL_TEMPLATE_REGEX;
        }

        @NotNull
        public final Regex getURL_REGEX() {
            return URL_REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

