/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.matchers;

import au.com.dius.pact.matchers.BodyMatcher;
import au.com.dius.pact.matchers.BodyMismatch;
import au.com.dius.pact.model.HttpPart;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.OptionalBodyKt;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lau/com/dius/pact/matchers/MultipartMessageBodyMatcher;", "Lau/com/dius/pact/matchers/BodyMatcher;", "()V", "compareContents", "", "Lau/com/dius/pact/matchers/BodyMismatch;", "expectedMultipart", "Ljavax/mail/BodyPart;", "actualMultipart", "compareHeaders", "matchBody", "expected", "Lau/com/dius/pact/model/HttpPart;", "actual", "allowUnexpectedKeys", "", "parseMultipart", "body", "", "contentType", "pact-jvm-matchers_2.12"})
public final class MultipartMessageBodyMatcher
implements BodyMatcher {
    @Override
    @NotNull
    public List<BodyMismatch> matchBody(@NotNull HttpPart expected, @NotNull HttpPart actual, boolean allowUnexpectedKeys) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
        OptionalBody expectedBody = expected.getBody();
        OptionalBody actualBody = actual.getBody();
        if (OptionalBodyKt.isMissing((OptionalBody)expectedBody)) {
            list = CollectionsKt.emptyList();
        } else if (OptionalBodyKt.isPresent((OptionalBody)expectedBody) && OptionalBodyKt.isNotPresent((OptionalBody)actualBody)) {
            list = CollectionsKt.listOf((Object)new BodyMismatch(OptionalBodyKt.orElse((OptionalBody)expectedBody, (String)""), null, "Expected a multipart body but was missing", null, null, 24, null));
        } else if (OptionalBodyKt.isEmpty((OptionalBody)expectedBody) && OptionalBodyKt.isEmpty((OptionalBody)actualBody)) {
            list = CollectionsKt.emptyList();
        } else {
            String string = expected.contentTypeHeader();
            String string2 = OptionalBodyKt.orElse((OptionalBody)expectedBody, (String)"");
            MultipartMessageBodyMatcher multipartMessageBodyMatcher = this;
            String string3 = string;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            BodyPart expectedMultipart = multipartMessageBodyMatcher.parseMultipart(string2, string4);
            String string5 = actual.contentTypeHeader();
            string2 = OptionalBodyKt.orElse((OptionalBody)actualBody, (String)"");
            multipartMessageBodyMatcher = this;
            String string6 = string5;
            if (string6 == null) {
                string6 = "";
            }
            string4 = string6;
            BodyPart actualMultipart = multipartMessageBodyMatcher.parseMultipart(string2, string4);
            list = CollectionsKt.plus((Collection)this.compareHeaders(expectedMultipart, actualMultipart), (Iterable)this.compareContents(expectedMultipart, actualMultipart));
        }
        return list;
    }

    private final List<BodyMismatch> compareContents(BodyPart expectedMultipart, BodyPart actualMultipart) {
        List list;
        String string;
        String string2 = string = expectedMultipart.getContent().toString();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expectedContents = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        CharSequence charSequence = actualMultipart.getContent().toString();
        String string3 = charSequence;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String actualContents = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        charSequence = expectedContents;
        if (charSequence.length() == 0 && (charSequence = (CharSequence)actualContents).length() == 0) {
            list = CollectionsKt.emptyList();
        } else {
            charSequence = expectedContents;
            if (charSequence.length() > 0 && (charSequence = (CharSequence)actualContents).length() > 0) {
                list = CollectionsKt.emptyList();
            } else {
                charSequence = expectedContents;
                if (charSequence.length() == 0 && (charSequence = (CharSequence)actualContents).length() > 0) {
                    charSequence = actualContents;
                    StringBuilder stringBuilder = new StringBuilder().append("Expected no contents, but received ");
                    String string4 = actualContents;
                    String string5 = expectedContents;
                    Charset charset = Charsets.UTF_8;
                    CharSequence charSequence2 = charSequence;
                    if (charSequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = ((String)charSequence2).getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] byArray2 = byArray;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 24;
                    String string6 = null;
                    String string7 = null;
                    String string8 = stringBuilder.append(byArray2.length).append(" bytes of content").toString();
                    String string9 = string4;
                    String string10 = string5;
                    list = CollectionsKt.listOf((Object)new BodyMismatch(string10, string9, string8, string7, string6, n, defaultConstructorMarker));
                } else {
                    list = CollectionsKt.listOf((Object)new BodyMismatch(expectedContents, actualContents, "Expected content with the multipart, but received no bytes of content", null, null, 24, null));
                }
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BodyMismatch> compareHeaders(BodyPart expectedMultipart, BodyPart actualMultipart) {
        void $receiver$iv;
        List mismatches = new ArrayList();
        Enumeration enumeration = expectedMultipart.getAllHeaders();
        if (enumeration == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Enumeration<javax.mail.Header>");
        }
        Enumeration enumeration2 = enumeration;
        enumeration2 = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration2));
        for (Object element$iv : $receiver$iv) {
            Header it = (Header)element$iv;
            Object[] header = actualMultipart.getHeader(it.getName());
            if (header != null) {
                String actualValue = ArraysKt.joinToString$default((Object[])header, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                if (!(Intrinsics.areEqual((Object)actualValue, (Object)it.getValue()) ^ true)) continue;
                mismatches.add(new BodyMismatch(it.toString(), null, "Expected a multipart header '" + it.getName() + "' with value '" + it.getValue() + "', but was '" + actualValue + '\'', null, null, 24, null));
                continue;
            }
            mismatches.add(new BodyMismatch(it.toString(), null, "Expected a multipart header '" + it.getName() + "', but was missing", null, null, 24, null));
        }
        return mismatches;
    }

    private final BodyPart parseMultipart(String body, String contentType) {
        MimeMultipart multipart = new MimeMultipart((DataSource)new ByteArrayDataSource(body, contentType));
        BodyPart bodyPart = multipart.getBodyPart(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)bodyPart, (String)"multipart.getBodyPart(0)");
        return bodyPart;
    }
}

