/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.matchers;

import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import groovy.json.JsonOutput;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u001a\u001a\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"NEW_LINE", "", "generateDiff", "", "", "expectedBodyString", "actualBodyString", "generateObjectDiff", "expected", "", "actual", "pact-jvm-matchers_2.12_main"})
public final class DiffUtilsKt {
    private static final char NEW_LINE = '\n';

    @NotNull
    public static final List<String> generateDiff(@NotNull String expectedBodyString, @NotNull String actualBodyString) {
        Intrinsics.checkParameterIsNotNull((Object)expectedBodyString, (String)"expectedBodyString");
        Intrinsics.checkParameterIsNotNull((Object)actualBodyString, (String)"actualBodyString");
        List expectedLines = StringsKt.split$default((CharSequence)expectedBodyString, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        List actualLines = StringsKt.split$default((CharSequence)actualBodyString, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        Patch patch = DiffUtils.diff((List)expectedLines, (List)actualLines);
        List diff = new ArrayList();
        Iterable $receiver$iv = patch.getDeltas();
        for (Object element$iv : $receiver$iv) {
            String it;
            Delta delta = (Delta)element$iv;
            if (delta.getOriginal().getPosition() >= 1 && (diff.isEmpty() || Intrinsics.areEqual((Object)((String)expectedLines.get(delta.getOriginal().getPosition() - 1)), (Object)((String)CollectionsKt.last((List)diff))) ^ true)) {
                diff.add(expectedLines.get(delta.getOriginal().getPosition() - 1));
            }
            Iterable $receiver$iv2 = delta.getOriginal().getLines();
            for (Object element$iv2 : $receiver$iv2) {
                it = (String)element$iv2;
                diff.add('-' + it);
            }
            $receiver$iv2 = delta.getRevised().getLines();
            for (Object element$iv2 : $receiver$iv2) {
                it = (String)element$iv2;
                diff.add('+' + it);
            }
            int pos = delta.getOriginal().getPosition() + delta.getOriginal().getLines().size();
            if (pos >= expectedLines.size()) continue;
            diff.add(expectedLines.get(pos));
        }
        return diff;
    }

    @NotNull
    public static final String generateObjectDiff(@Nullable Object expected, @Nullable Object actual) {
        String actualJson = "";
        if (actual != null) {
            String string = JsonOutput.prettyPrint((String)JsonOutput.toJson((Object)actual));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JsonOutput.prettyPrint(JsonOutput.toJson(actual))");
            actualJson = string;
        }
        String expectedJson = "";
        if (expected != null) {
            String string = JsonOutput.prettyPrint((String)JsonOutput.toJson((Object)expected));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JsonOutput.prettyPrint(J\u2026nOutput.toJson(expected))");
            expectedJson = string;
        }
        return CollectionsKt.joinToString$default((Iterable)DiffUtilsKt.generateDiff(expectedJson, actualJson), (CharSequence)String.valueOf('\n'), null, null, (int)0, null, null, (int)62, null);
    }
}

