/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.model.Request;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.model.Response;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import nl.flotsam.xeger.Xeger;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;
import scala.collection.JavaConversions$;
import scala.collection.Seq;

public class PactDslResponse {
    private static final String CONTENT_TYPE = "Content-Type";
    private final ConsumerPactBuilder consumerPactBuilder;
    private PactDslRequestWithPath request;
    private int responseStatus = 200;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private OptionalBody responseBody = OptionalBody.missing();
    private Map<String, Map<String, Object>> responseMatchers = new HashMap<String, Map<String, Object>>();

    public PactDslResponse(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath request) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.request = request;
    }

    public PactDslResponse status(int status) {
        this.responseStatus = status;
        return this;
    }

    public PactDslResponse headers(Map<String, String> headers) {
        this.responseHeaders.putAll(headers);
        return this;
    }

    public PactDslResponse body(String body) {
        this.responseBody = OptionalBody.body((String)body);
        return this;
    }

    public PactDslResponse body(String body, String mimeType) {
        this.responseBody = OptionalBody.body((String)body);
        this.responseHeaders.put(CONTENT_TYPE, mimeType);
        return this;
    }

    public PactDslResponse body(String body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslResponse body(JSONObject body) {
        this.responseBody = OptionalBody.body((String)body.toString());
        if (!this.responseHeaders.containsKey(CONTENT_TYPE)) {
            this.responseHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslResponse body(DslPart body) {
        DslPart parent = body.close();
        for (String matcherName : parent.matchers.keySet()) {
            this.responseMatchers.put("$.body" + matcherName, parent.matchers.get(matcherName));
        }
        this.responseBody = parent.getBody() != null ? OptionalBody.body((String)parent.getBody().toString()) : OptionalBody.nullBody();
        if (!this.responseHeaders.containsKey(CONTENT_TYPE)) {
            this.responseHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslResponse body(Document body) throws TransformerException {
        this.responseBody = OptionalBody.body((String)ConsumerPactBuilder.xmlToString(body));
        if (!this.responseHeaders.containsKey(CONTENT_TYPE)) {
            this.responseHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_XML.toString());
        }
        return this;
    }

    public PactDslResponse matchHeader(String header, String regexp) {
        return this.matchHeader(header, regexp, new Xeger(regexp).generate());
    }

    public PactDslResponse matchHeader(String header, String regexp, String headerExample) {
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("regex", regexp);
        this.responseMatchers.put("$.headers." + header, matcher);
        this.responseHeaders.put(header, headerExample);
        return this;
    }

    private void addInteraction() {
        this.consumerPactBuilder.getInteractions().add(new RequestResponseInteraction(this.request.description, this.request.state, new Request(this.request.requestMethod, this.request.path, PactReader.queryStringToMap((String)this.request.query, (boolean)false), this.request.requestHeaders, this.request.requestBody, this.request.requestMatchers), new Response(Integer.valueOf(this.responseStatus), this.responseHeaders, this.responseBody, this.responseMatchers)));
    }

    public PactFragment toFragment() {
        this.addInteraction();
        return new PactFragment(this.request.consumer, this.request.provider, (Seq<RequestResponseInteraction>)JavaConversions$.MODULE$.asScalaBuffer(this.consumerPactBuilder.getInteractions()).toSeq());
    }

    public PactDslRequestWithPath uponReceiving(String description) {
        this.addInteraction();
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.request, description);
    }

    public PactDslWithState given(String state) {
        this.addInteraction();
        return new PactDslWithState(this.consumerPactBuilder, this.request.consumer.getName(), this.request.provider.getName(), state);
    }
}

