/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.model.OptionalBody;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import nl.flotsam.xeger.Xeger;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class PactDslRequestWithoutPath {
    private static final String CONTENT_TYPE = "Content-Type";
    private final ConsumerPactBuilder consumerPactBuilder;
    private PactDslWithState pactDslWithState;
    private String description;
    private String requestMethod;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private String query;
    private OptionalBody requestBody = OptionalBody.missing();
    private Map<String, Map<String, Object>> requestMatchers = new HashMap<String, Map<String, Object>>();
    private String consumerName;
    private String providerName;

    public PactDslRequestWithoutPath(ConsumerPactBuilder consumerPactBuilder, PactDslWithState pactDslWithState, String description) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.pactDslWithState = pactDslWithState;
        this.description = description;
        this.consumerName = pactDslWithState.consumerName;
        this.providerName = pactDslWithState.providerName;
    }

    public PactDslRequestWithoutPath method(String method) {
        this.requestMethod = method;
        return this;
    }

    public PactDslRequestWithoutPath headers(Map<String, String> headers) {
        this.requestHeaders = new HashMap<String, String>(headers);
        return this;
    }

    public PactDslRequestWithoutPath query(String query) {
        this.query = query;
        return this;
    }

    public PactDslRequestWithoutPath body(String body) {
        this.requestBody = OptionalBody.body((String)body);
        return this;
    }

    public PactDslRequestWithoutPath body(String body, String mimeType) {
        this.requestBody = OptionalBody.body((String)body);
        this.requestHeaders.put(CONTENT_TYPE, mimeType);
        return this;
    }

    public PactDslRequestWithoutPath body(String body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslRequestWithoutPath body(JSONObject body) {
        this.requestBody = OptionalBody.body((String)body.toString());
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslRequestWithoutPath body(DslPart body) {
        DslPart parent = body.close();
        this.requestMatchers = new HashMap<String, Map<String, Object>>();
        for (String matcherName : parent.matchers.keySet()) {
            this.requestMatchers.put("$.body" + matcherName, parent.matchers.get(matcherName));
        }
        this.requestBody = OptionalBody.body((String)parent.toString());
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslRequestWithoutPath body(Document body) throws TransformerException {
        this.requestBody = OptionalBody.body((String)ConsumerPactBuilder.xmlToString(body));
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_XML.toString());
        }
        return this;
    }

    public PactDslRequestWithPath path(String path) {
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.consumerName, this.providerName, this.pactDslWithState.state, this.description, path, this.requestMethod, this.requestHeaders, this.query, this.requestBody, this.requestMatchers);
    }

    public PactDslRequestWithPath matchPath(String pathRegex) {
        return this.matchPath(pathRegex, new Xeger(pathRegex).generate());
    }

    public PactDslRequestWithPath matchPath(String pathRegex, String path) {
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("regex", pathRegex);
        this.requestMatchers.put("$.path", matcher);
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.consumerName, this.providerName, this.pactDslWithState.state, this.description, path, this.requestMethod, this.requestHeaders, this.query, this.requestBody, this.requestMatchers);
    }
}

