/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerInteractionJavaDsl;
import au.com.dius.pact.consumer.ConsumerPact;
import au.com.dius.pact.consumer.ConsumerPactJavaDsl;
import au.com.dius.pact.consumer.PactServerConfig;
import au.com.dius.pact.consumer.PactVerification;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.Pact;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractConsumerPactTest {
    protected abstract Interaction createInteraction(ConsumerInteractionJavaDsl var1);

    protected abstract String providerName();

    protected abstract String consumerName();

    private Pact createPact() {
        return ConsumerPactJavaDsl.makePact().withConsumer(this.consumerName()).withProvider(this.providerName()).withInteractions(this.createInteraction(new ConsumerInteractionJavaDsl()));
    }

    protected abstract void runTest(String var1);

    @Test
    public void testPact() {
        Pact pact = this.createPact();
        int n = (Integer)PactServerConfig.randomPort().get();
        final PactServerConfig pactServerConfig = new PactServerConfig(n, "localhost");
        String string = ((Interaction)pact.interactions().head()).providerState();
        PactVerification.VerificationResult verificationResult = new ConsumerPact(pact).runConsumer(pactServerConfig, string, new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractConsumerPactTest.this.runTest(pactServerConfig.url());
                }
                catch (Exception exception) {
                    Assert.fail((String)("error thrown" + exception));
                }
            }
        });
        Assert.assertEquals((Object)ConsumerInteractionJavaDsl.pactVerified, (Object)verificationResult);
    }
}

