/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.Pact;
import au.com.dius.pact.consumer.PactError;
import au.com.dius.pact.consumer.PactMismatch;
import au.com.dius.pact.consumer.PactMismatchException;
import au.com.dius.pact.consumer.PactVerification;
import au.com.dius.pact.consumer.PactVerifications;
import au.com.dius.pact.consumer.PactVerified$;
import au.com.dius.pact.consumer.TestRun;
import au.com.dius.pact.consumer.UserCodeFailed;
import au.com.dius.pact.consumer.VerificationResult;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.model.MockHttpsKeystoreProviderConfig;
import au.com.dius.pact.model.MockHttpsProviderConfig;
import au.com.dius.pact.model.MockProviderConfig;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.PactSpecVersion;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Deprecated
public class PactProviderRule
extends ExternalResource {
    private static final VerificationResult PACT_VERIFIED = PactVerified$.MODULE$;
    private final String provider;
    private final Object target;
    private MockProviderConfig config;
    private Map<String, PactFragment> fragments;

    public PactProviderRule(String provider, String host, Integer port, PactSpecVersion pactVersion, Object target) {
        this.provider = provider;
        this.target = target;
        this.config = host == null && port == null ? MockProviderConfig.createDefault((PactSpecVersion)pactVersion) : MockProviderConfig.httpConfig((String)host, (int)port, (PactSpecVersion)pactVersion);
    }

    public PactProviderRule(String provider, String host, Integer port, boolean https, PactSpecVersion pactVersion, Object target) {
        this(provider, host, port, pactVersion, target);
        if (https) {
            this.config = MockHttpsProviderConfig.httpsConfig((String)host, (int)port, (PactSpecVersion)pactVersion);
        }
    }

    public PactProviderRule(String provider, String host, Integer port, boolean https, String keystore, String password, PactSpecVersion pactVersion, Object target) {
        this(provider, host, port, pactVersion, target);
        if (https) {
            this.config = MockHttpsKeystoreProviderConfig.httpsKeystoreConfig((String)host, (int)port, (String)keystore, (String)password, (PactSpecVersion)pactVersion);
        }
    }

    public PactProviderRule(String provider, String host, Integer port, Object target) {
        this(provider, host, port, PactSpecVersion.V3, target);
    }

    public PactProviderRule(String provider, Object target) {
        this(provider, null, null, PactSpecVersion.V3, target);
    }

    public PactProviderRule(String provider, PactSpecVersion pactSpecVersion, Object target) {
        this(provider, null, null, pactSpecVersion, target);
    }

    public MockProviderConfig getConfig() {
        return this.config;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerifications pactVerifications = (PactVerifications)description.getAnnotation(PactVerifications.class);
                if (pactVerifications != null) {
                    PactProviderRule.this.evaluatePactVerifications(pactVerifications, base);
                    return;
                }
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                Map<String, PactFragment> pacts = PactProviderRule.this.getPacts(pactDef.fragment());
                Optional<PactFragment> fragment = pactDef.value().length == 1 && StringUtils.isEmpty((CharSequence)pactDef.value()[0]) ? pacts.values().stream().findFirst() : Arrays.asList(pactDef.value()).stream().map(pacts::get).filter(p -> p != null).findFirst();
                if (!fragment.isPresent()) {
                    base.evaluate();
                    return;
                }
                VerificationResult result = PactProviderRule.this.runPactTest(base, fragment.get());
                PactProviderRule.this.validateResult(result, pactDef);
            }
        };
    }

    private void evaluatePactVerifications(PactVerifications pactVerifications, Statement base) throws Throwable {
        PactFragment pactFragment;
        Optional<PactVerification> possiblePactVerification = this.findPactVerification(pactVerifications);
        if (!possiblePactVerification.isPresent()) {
            base.evaluate();
            return;
        }
        PactVerification pactVerification = possiblePactVerification.get();
        Optional<Method> possiblePactMethod = this.findPactMethod(pactVerification);
        if (!possiblePactMethod.isPresent()) {
            throw new UnsupportedOperationException("Could not find method with @Pact for the provider " + this.provider);
        }
        Method method = possiblePactMethod.get();
        Pact pact = method.getAnnotation(Pact.class);
        PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)pact.consumer()).hasPactWith(this.provider);
        try {
            pactFragment = (PactFragment)method.invoke(this.target, dslBuilder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke pact method", e);
        }
        VerificationResult result = this.runPactTest(base, pactFragment);
        this.validateResult(result, pactVerification);
    }

    private Optional<PactVerification> findPactVerification(PactVerifications pactVerifications) {
        PactVerification[] pactVerificationValues = pactVerifications.value();
        return Arrays.stream(pactVerificationValues).filter(p -> {
            String[] providers = p.value();
            if (providers.length != 1) {
                throw new IllegalArgumentException("Each @PactVerification must specify one and only provider when using @PactVerifications");
            }
            String provider = providers[0];
            return provider.equals(this.provider);
        }).findFirst();
    }

    private Optional<Method> findPactMethod(PactVerification pactVerification) {
        String pactFragment = pactVerification.fragment();
        for (Method method : this.target.getClass().getMethods()) {
            Pact pact = method.getAnnotation(Pact.class);
            if (pact == null || !pact.provider().equals(this.provider) || !pactFragment.isEmpty() && !pactFragment.equals(method.getName())) continue;
            this.validatePactSignature(method);
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private void validatePactSignature(Method method) {
        boolean hasValidPactSignature;
        boolean bl = hasValidPactSignature = PactFragment.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(PactDslWithProvider.class);
        if (!hasValidPactSignature) {
            throw new UnsupportedOperationException("Method " + method.getName() + " does not conform required method signature 'public PactFragment xxx(PactDslWithProvider builder)'");
        }
    }

    private VerificationResult runPactTest(final Statement base, PactFragment pactFragment) {
        return pactFragment.runConsumer(this.config, new TestRun(){

            public void run(MockProviderConfig config) throws Throwable {
                base.evaluate();
            }
        });
    }

    private void validateResult(VerificationResult result, PactVerification pactVerification) throws Throwable {
        if (!result.equals(PACT_VERIFIED)) {
            if (result instanceof PactError) {
                throw ((PactError)result).error();
            }
            if (result instanceof UserCodeFailed) {
                throw (RuntimeException)((UserCodeFailed)result).error();
            }
            if (result instanceof PactMismatch) {
                PactMismatch mismatch = (PactMismatch)result;
                throw new PactMismatchException(mismatch);
            }
        }
    }

    protected Map<String, PactFragment> getPacts(String fragment) {
        if (this.fragments == null) {
            this.fragments = new HashMap<String, PactFragment>();
            for (Method m : this.target.getClass().getMethods()) {
                Pact pact;
                if (!this.conformsToSignature(m) || !this.methodMatchesFragment(m, fragment) || !StringUtils.isEmpty((CharSequence)(pact = m.getAnnotation(Pact.class)).provider()) && !this.provider.equals(pact.provider())) continue;
                PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)pact.consumer()).hasPactWith(this.provider);
                try {
                    this.fragments.put(this.provider, (PactFragment)m.invoke(this.target, dslBuilder));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke pact method", e);
                }
            }
        }
        return this.fragments;
    }

    private boolean methodMatchesFragment(Method m, String fragment) {
        return StringUtils.isEmpty((CharSequence)fragment) || m.getName().equals(fragment);
    }

    private boolean conformsToSignature(Method m) {
        boolean conforms;
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = conforms = pact != null && PactFragment.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(PactDslWithProvider.class);
        if (!conforms && pact != null) {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public PactFragment xxx(PactDslWithProvider builder)'");
        }
        return conforms;
    }
}

