/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.DslPart;
import au.com.dius.pact.consumer.PactDslJsonBody;
import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.Interaction$;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.Provider;
import au.com.dius.pact.model.Request$;
import au.com.dius.pact.model.Response$;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public class ConsumerPactBuilder {
    private String consumerName;

    public ConsumerPactBuilder(String consumer) {
        this.consumerName = consumer;
    }

    public static ConsumerPactBuilder consumer(String consumer) {
        return new ConsumerPactBuilder(consumer);
    }

    public PactDslWithProvider hasPactWith(String provider) {
        return new PactDslWithProvider(provider);
    }

    public static PactDslJsonBody jsonBody() {
        return new PactDslJsonBody();
    }

    public class PactDslResponse {
        private PactDslRequestWithPath existing;
        private int responseStatus = 200;
        private Map<String, String> responseHeaders = Collections.emptyMap();
        private String responseBody;
        private Map<String, Object> responseMatchers = Collections.emptyMap();

        public PactDslResponse(PactDslRequestWithPath existing) {
            this.existing = existing;
        }

        public PactDslResponse status(int status) {
            this.responseStatus = status;
            return this;
        }

        public PactDslResponse headers(Map<String, String> headers) {
            this.responseHeaders = headers;
            return this;
        }

        public PactDslResponse body(String body) {
            this.responseBody = body;
            return this;
        }

        public PactDslResponse body(JSONObject body) {
            this.responseBody = body.toString();
            return this;
        }

        public PactDslResponse body(DslPart body) {
            this.responseMatchers = body.getMatchers();
            this.responseBody = body.toString();
            return this;
        }

        private void addInteraction() {
            Interaction currentInteraction = this.existing.state == null ? Interaction$.MODULE$.apply(this.existing.description, None$.apply((Object)this.existing.state), Request$.MODULE$.apply(this.existing.requestMethod, this.existing.path, this.existing.query, this.existing.requestHeaders, this.existing.requestBody, this.existing.requestMatchers), Response$.MODULE$.apply(this.responseStatus, this.responseHeaders, this.responseBody, this.responseMatchers)) : Interaction$.MODULE$.apply(this.existing.description, (Option)Some$.MODULE$.apply((Object)this.existing.state), Request$.MODULE$.apply(this.existing.requestMethod, this.existing.path, this.existing.query, this.existing.requestHeaders, this.existing.requestBody, this.existing.requestMatchers), Response$.MODULE$.apply(this.responseStatus, this.responseHeaders, this.responseBody, this.responseMatchers));
            this.existing.interactions.add(currentInteraction);
        }

        public PactFragment toFragment() {
            this.addInteraction();
            return new PactFragment(this.existing.consumer, this.existing.provider, (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.existing.interactions).asScala());
        }

        public PactDslRequestWithPath uponReceiving(String description) {
            this.addInteraction();
            return new PactDslRequestWithPath(this.existing, description);
        }
    }

    public class PactDslRequestWithPath {
        private Consumer consumer;
        private Provider provider;
        private String state;
        private String description;
        private String path = "/";
        private String requestMethod = "GET";
        private Map<String, String> requestHeaders = Collections.emptyMap();
        private String query;
        private String requestBody;
        private Map<String, Object> requestMatchers = Collections.emptyMap();
        private List<Interaction> interactions = new ArrayList<Interaction>();

        public PactDslRequestWithPath(String consumerName, String providerName, String state, String description, String path, String requestMethod, Map<String, String> requestHeaders, String query, String requestBody, Map<String, Object> requestMatchers) {
            this.requestMatchers = requestMatchers;
            this.consumer = new Consumer(consumerName);
            this.provider = new Provider(providerName);
            this.state = state;
            this.description = description;
            this.path = path;
            this.requestMethod = requestMethod;
            this.requestHeaders = requestHeaders;
            this.query = query;
            this.requestBody = requestBody;
            this.requestMatchers = requestMatchers;
        }

        public PactDslRequestWithPath(PactDslRequestWithPath existing, String description) {
            this.consumer = existing.consumer;
            this.provider = existing.provider;
            this.state = existing.state;
            this.description = description;
            this.interactions = existing.interactions;
        }

        public PactDslRequestWithPath method(String method) {
            this.requestMethod = method;
            return this;
        }

        public PactDslRequestWithPath headers(Map<String, String> headers) {
            this.requestHeaders = headers;
            return this;
        }

        public PactDslRequestWithPath query(String query) {
            this.query = query;
            return this;
        }

        public PactDslRequestWithPath body(String body) {
            this.requestBody = body;
            return this;
        }

        public PactDslRequestWithPath body(JSONObject body) {
            this.requestBody = body.toString();
            return this;
        }

        public PactDslRequestWithPath body(DslPart body) {
            this.requestMatchers = body.getMatchers();
            this.requestBody = body.toString();
            return this;
        }

        public PactDslRequestWithPath path(String path) {
            this.path = path;
            return this;
        }

        public PactDslResponse willRespondWith() {
            return new PactDslResponse(this);
        }
    }

    public class PactDslWithProvider {
        private String providerName;

        public PactDslWithProvider(String provider) {
            this.providerName = provider;
        }

        public PactDslWithState given(String state) {
            return new PactDslWithState(state);
        }

        public PactDslWithState.PactDslRequestWithoutPath uponReceiving(String description) {
            return new PactDslWithState(null).uponReceiving(description);
        }

        public class PactDslWithState {
            private String state;

            public PactDslWithState(String state) {
                this.state = state;
            }

            public PactDslRequestWithoutPath uponReceiving(String description) {
                return new PactDslRequestWithoutPath(description);
            }

            public class PactDslRequestWithoutPath {
                private String description;
                private String requestMethod;
                private Map<String, String> requestHeaders = Collections.emptyMap();
                private String query;
                private String requestBody;
                private Map<String, Object> requestMatchers = Collections.emptyMap();

                public PactDslRequestWithoutPath(String description) {
                    this.description = description;
                }

                public PactDslRequestWithoutPath method(String method) {
                    this.requestMethod = method;
                    return this;
                }

                public PactDslRequestWithoutPath headers(Map<String, String> headers) {
                    this.requestHeaders = headers;
                    return this;
                }

                public PactDslRequestWithoutPath query(String query) {
                    this.query = query;
                    return this;
                }

                public PactDslRequestWithoutPath body(String body) {
                    this.requestBody = body;
                    return this;
                }

                public PactDslRequestWithoutPath body(JSONObject body) {
                    this.requestBody = body.toString();
                    return this;
                }

                public PactDslRequestWithoutPath body(PactDslJsonBody body) {
                    this.requestMatchers = body.getMatchers();
                    this.requestBody = body.toString();
                    return this;
                }

                public PactDslRequestWithPath path(String path) {
                    return new PactDslRequestWithPath(ConsumerPactBuilder.this.consumerName, PactDslWithProvider.this.providerName, PactDslWithState.this.state, this.description, path, this.requestMethod, this.requestHeaders, this.query, this.requestBody, this.requestMatchers);
                }
            }
        }
    }
}

