/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.Pact;
import au.com.dius.pact.consumer.PactError;
import au.com.dius.pact.consumer.PactMismatch;
import au.com.dius.pact.consumer.PactMismatchException;
import au.com.dius.pact.consumer.PactVerification;
import au.com.dius.pact.consumer.PactVerified$;
import au.com.dius.pact.consumer.TestRun;
import au.com.dius.pact.consumer.UserCodeFailed;
import au.com.dius.pact.consumer.VerificationResult;
import au.com.dius.pact.model.MockProviderConfig;
import au.com.dius.pact.model.MockProviderConfig$;
import au.com.dius.pact.model.PactConfig;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.PactSpecVersion;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PactRule
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactRule.class);
    public static VerificationResult PACT_VERIFIED = PactVerified$.MODULE$;
    private Map<String, PactFragment> fragments;
    private Object target;
    private final MockProviderConfig config;

    public PactRule(String host, int port, Object target) {
        this.config = new MockProviderConfig(port, host, new PactConfig(PactSpecVersion.V2));
        this.target = target;
    }

    public PactRule(String host, Object target) {
        this.config = MockProviderConfig$.MODULE$.createDefault(host, new PactConfig(PactSpecVersion.V2));
        this.target = target;
    }

    public PactRule(Object target) {
        this.config = MockProviderConfig$.MODULE$.createDefault(new PactConfig(PactSpecVersion.V2));
        this.target = target;
    }

    public MockProviderConfig getConfig() {
        return this.config;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                PactFragment fragment = PactRule.this.getPacts().get(pactDef.value());
                if (fragment == null) {
                    throw new UnsupportedOperationException("Fragment not found: " + pactDef.value());
                }
                VerificationResult result = fragment.runConsumer(PactRule.this.config, new TestRun(){

                    public void run(MockProviderConfig config) throws Throwable {
                        base.evaluate();
                    }
                });
                if (!result.equals(PACT_VERIFIED)) {
                    if (result instanceof PactError) {
                        throw new RuntimeException(((PactError)result).error());
                    }
                    if (result instanceof UserCodeFailed) {
                        throw new RuntimeException((Throwable)((UserCodeFailed)result).error());
                    }
                    if (result instanceof PactMismatch) {
                        PactMismatch mismatch = (PactMismatch)result;
                        throw new PactMismatchException(mismatch);
                    }
                }
            }
        };
    }

    protected Map<String, PactFragment> getPacts() {
        if (this.fragments == null) {
            this.fragments = new HashMap<String, PactFragment>();
            for (Method m : this.target.getClass().getMethods()) {
                if (!this.conformsToSigniture(m)) continue;
                Pact pact = m.getAnnotation(Pact.class);
                ConsumerPactBuilder.PactDslWithProvider.PactDslWithState dslBuilder = ConsumerPactBuilder.consumer((String)pact.consumer()).hasPactWith(pact.provider()).given(pact.state());
                try {
                    this.fragments.put(pact.state(), (PactFragment)m.invoke(this.target, dslBuilder));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to invoke pact method", (Throwable)e);
                    throw new RuntimeException("Failed to invoke pact method", e);
                }
            }
        }
        return this.fragments;
    }

    private boolean conformsToSigniture(Method m) {
        boolean conforms;
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = conforms = pact != null && PactFragment.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(ConsumerPactBuilder.PactDslWithProvider.PactDslWithState.class);
        if (!conforms && pact != null) {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public PactFragment xxx(PactDslWithState builder)'");
        }
        return conforms;
    }
}

