/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.PactError;
import au.com.dius.pact.consumer.PactMismatch;
import au.com.dius.pact.consumer.PactMismatchException;
import au.com.dius.pact.consumer.PactVerified$;
import au.com.dius.pact.consumer.TestRun;
import au.com.dius.pact.consumer.UserCodeFailed;
import au.com.dius.pact.consumer.VerificationResult;
import au.com.dius.pact.model.MockProviderConfig;
import au.com.dius.pact.model.PactConfig;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.PactSpecVersion;
import java.io.IOException;
import org.junit.Test;

public abstract class ConsumerPactTest {
    public static VerificationResult PACT_VERIFIED = PactVerified$.MODULE$;

    protected abstract PactFragment createFragment(ConsumerPactBuilder.PactDslWithProvider var1);

    protected abstract String providerName();

    protected abstract String consumerName();

    protected abstract void runTest(String var1) throws IOException;

    @Test
    public void testPact() throws Throwable {
        MockProviderConfig config;
        PactFragment fragment = this.createFragment(ConsumerPactBuilder.consumer((String)this.consumerName()).hasPactWith(this.providerName()));
        VerificationResult result = fragment.runConsumer(config = MockProviderConfig.createDefault((PactConfig)new PactConfig(this.getSpecificationVersion())), new TestRun(){

            public void run(MockProviderConfig config) throws IOException {
                ConsumerPactTest.this.runTest(config.url());
            }
        });
        if (!result.equals(PACT_VERIFIED)) {
            if (result instanceof PactError) {
                throw ((PactError)result).error();
            }
            if (result instanceof UserCodeFailed) {
                throw (RuntimeException)((UserCodeFailed)result).error();
            }
            if (result instanceof PactMismatch) {
                PactMismatch mismatch = (PactMismatch)result;
                throw new PactMismatchException(mismatch);
            }
        }
    }

    protected PactSpecVersion getSpecificationVersion() {
        return PactSpecVersion.V2;
    }
}

