/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.fatboy.utils;

import au.com.dius.fatboy.utils.LambdaUtils;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ReflectionUtils {
    public static <T> Constructor<T> getDefaultOrFirstConstructor(Class<T> clazz) {
        Constructor<T> defaultConstructor = ReflectionUtils.findDefaultConstructor(clazz);
        if (defaultConstructor == null) {
            return ReflectionUtils.findFirstConstructor(clazz);
        }
        return defaultConstructor;
    }

    public static List<Field> getAllDeclaredFields(Class clazz) {
        List<Field> declaredFields = ReflectionUtils.getFieldsInSuperclasses(clazz);
        return ReflectionUtils.excludeSyntheticAndStaticFields(declaredFields);
    }

    private static <T> Constructor<T> findDefaultConstructor(Class<T> clazz) {
        return Lists.newArrayList((Object[])clazz.getDeclaredConstructors()).stream().filter(x -> x.getParameters().length == 0).findFirst().orElse(null);
    }

    private static <T> Constructor<T> findFirstConstructor(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        return constructors.length == 0 ? null : constructors[0];
    }

    private static List<Field> excludeSyntheticAndStaticFields(List<Field> declaredFields) {
        return declaredFields.stream().filter(x -> !x.isSynthetic()).filter(x -> !Modifier.isStatic(x.getModifiers())).collect(Collectors.toList());
    }

    private static List<Field> getFieldsInSuperclasses(Class clazz) {
        ArrayList declaredFields = Lists.newArrayList((Object[])clazz.getDeclaredFields());
        for (Class superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            declaredFields.addAll(Lists.newArrayList((Object[])superclass.getDeclaredFields()));
        }
        return declaredFields;
    }

    public static Field getField(Class clazz, String fieldName) {
        return LambdaUtils.unchecked(() -> clazz.getDeclaredField(fieldName));
    }
}

