/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.fatboy.config;

import au.com.dius.fatboy.factory.ClassFactory;
import au.com.dius.fatboy.factory.collections.CollectionFactory;
import au.com.dius.fatboy.factory.config.FactoryHint;
import au.com.dius.fatboy.factory.config.FieldLength;
import au.com.dius.fatboy.factory.primitives.IntFactory;
import au.com.dius.fatboy.factory.primitives.LongFactory;
import au.com.dius.fatboy.factory.primitives.StringFactory;
import au.com.dius.fatboy.factory.semantic.date.DateStringSemanticFieldFactory;
import au.com.dius.fatboy.factory.semantic.date.DateTimeStringSemanticFieldFactory;
import au.com.dius.fatboy.factory.semantic.date.TimeStringSemanticFieldFactory;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.joda.time.format.DateTimeFormatter;

public class Configurer {
    private static final Configurer INSTANCE = new Configurer();
    private final Multimap<Class<? extends ClassFactory>, FactoryHint> configuration = this.defaultConfiguration();

    private Configurer() {
    }

    public Configurer dateTimeStrings(DateTimeFormatter formatter) {
        this.replace(StringFactory.class, new DateTimeStringSemanticFieldFactory(formatter));
        return this;
    }

    public Configurer dateStrings(DateTimeFormatter formatter) {
        this.replace(StringFactory.class, new DateStringSemanticFieldFactory(formatter));
        return this;
    }

    public Configurer timeStrings(DateTimeFormatter formatter) {
        this.replace(StringFactory.class, new TimeStringSemanticFieldFactory(formatter));
        return this;
    }

    public Configurer collections(FieldLength fieldLength) {
        this.replace(CollectionFactory.class, fieldLength);
        return this;
    }

    public Configurer strings(FieldLength fieldLength) {
        this.replace(StringFactory.class, fieldLength);
        return this;
    }

    public Configurer integers(FieldLength fieldLength) {
        this.replace(IntFactory.class, fieldLength);
        return this;
    }

    public Configurer longints(FieldLength fieldLength) {
        this.replace(LongFactory.class, fieldLength);
        return this;
    }

    private <T extends ClassFactory> void replace(Class<T> factoryClass, FactoryHint replacement) {
        Collection factoryHints = this.configuration.get(factoryClass);
        FactoryHint existingHint = factoryHints.stream().filter(x -> x.getClass() == replacement.getClass()).findFirst().orElse(null);
        factoryHints.remove(existingHint);
        factoryHints.add(replacement);
    }

    private Multimap<Class<? extends ClassFactory>, FactoryHint> defaultConfiguration() {
        ArrayListMultimap configuration = ArrayListMultimap.create();
        configuration.put(CollectionFactory.class, (Object)FieldLength.random(2L, 5L));
        configuration.put(StringFactory.class, (Object)FieldLength.random(10L, 25L));
        configuration.put(StringFactory.class, (Object)new DateTimeStringSemanticFieldFactory());
        configuration.put(StringFactory.class, (Object)new DateStringSemanticFieldFactory());
        configuration.put(StringFactory.class, (Object)new TimeStringSemanticFieldFactory());
        configuration.put(IntFactory.class, (Object)FieldLength.random(0L, 100000L));
        configuration.put(LongFactory.class, (Object)FieldLength.random(0L, 1000000L));
        return configuration;
    }

    public static void reset() {
        Configurer.INSTANCE.configuration.clear();
        Configurer.INSTANCE.configuration.putAll(INSTANCE.defaultConfiguration());
    }

    public static void applyHints(ClassFactory factory) {
        Configurer.INSTANCE.configuration.get(factory.getClass()).forEach(factory::putHint);
    }

    public static Configurer configure() {
        return INSTANCE;
    }
}

