/*
 * Decompiled with CFR 0.152.
 */
package au.com.ds.ef;

import au.com.ds.ef.EventEnum;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.Transition;
import au.com.ds.ef.err.DefinitionError;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class TransitionCollection {
    private Multimap<StateEnum, Transition> transitionFromState = HashMultimap.create();
    private Set<StateEnum> finalStates = Sets.newHashSet();

    protected TransitionCollection(Collection<Transition> transitions, boolean validate) {
        if (transitions != null) {
            for (Transition transition : transitions) {
                this.transitionFromState.put((Object)transition.getStateFrom(), (Object)transition);
                if (!transition.isFinal()) continue;
                this.finalStates.add(transition.getStateTo());
            }
        }
        if (validate) {
            if (transitions == null || transitions.isEmpty()) {
                throw new DefinitionError("No transitions defined");
            }
            HashSet processedTransitions = Sets.newHashSet();
            for (Transition transition : transitions) {
                StateEnum stateFrom = transition.getStateFrom();
                if (this.finalStates.contains(stateFrom)) {
                    throw new DefinitionError("Some events defined for final State: " + stateFrom);
                }
                if (processedTransitions.contains(transition)) {
                    throw new DefinitionError("Ambiguous transitions: " + transition);
                }
                StateEnum stateTo = transition.getStateTo();
                if (!this.finalStates.contains(stateTo) && !this.transitionFromState.containsKey((Object)stateTo)) {
                    throw new DefinitionError("No events defined for non-final State: " + stateTo);
                }
                if (stateFrom.equals(stateTo)) {
                    throw new DefinitionError("Circular transition: " + transition);
                }
                processedTransitions.add(transition);
            }
        }
    }

    public Optional<Transition> getTransition(StateEnum stateFrom, EventEnum event) {
        return FluentIterable.from((Iterable)this.transitionFromState.get((Object)stateFrom)).firstMatch((Predicate)new TransitionWithEvent(event));
    }

    public List<Transition> getTransitions(StateEnum stateFrom) {
        return Lists.newArrayList((Iterable)this.transitionFromState.get((Object)stateFrom));
    }

    protected boolean isFinal(StateEnum state) {
        return this.finalStates.contains(state);
    }

    private static final class TransitionWithEvent
    implements Predicate<Transition> {
        private EventEnum event;

        private TransitionWithEvent(EventEnum event) {
            this.event = event;
        }

        public boolean apply(Transition transition) {
            return transition.getEvent() == this.event;
        }
    }
}

