/*
 * Decompiled with CFR 0.152.
 */
package au.com.ds.ef;

import au.com.ds.ef.EasyFlow;
import au.com.ds.ef.EventEnum;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.Transition;
import au.com.ds.ef.err.LogicViolationError;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class StatefulContext
implements Serializable {
    private static final long serialVersionUID = 2324535129909715649L;
    private static volatile long idCounter = 1L;
    private final String id;
    private EasyFlow flow;
    private StateEnum state;
    private EventEnum lastEvent;
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final CountDownLatch completionLatch = new CountDownLatch(1);

    public StatefulContext() {
        this.id = this.newId() + ":" + this.getClass().getSimpleName();
    }

    public StatefulContext(String aId) {
        this.id = aId + ":" + this.getClass().getSimpleName();
    }

    public String getId() {
        return this.id;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public StateEnum getState() {
        return this.state;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatefulContext other = (StatefulContext)obj;
        return this.id == other.id;
    }

    public boolean safeTrigger(EventEnum event) {
        return this.flow.safeTrigger(event, this);
    }

    public void trigger(EventEnum event) throws LogicViolationError {
        this.flow.trigger(event, this);
    }

    protected void setFlow(EasyFlow<? extends StatefulContext> flow) {
        this.flow = flow;
    }

    protected long newId() {
        return idCounter++;
    }

    public boolean isTerminated() {
        return this.terminated.get();
    }

    public boolean isRunning() {
        return this.isStarted() && !this.terminated.get();
    }

    public boolean isStarted() {
        return this.state != null;
    }

    protected void setTerminated() {
        this.terminated.set(true);
        this.completionLatch.countDown();
    }

    public EventEnum getLastEvent() {
        return this.lastEvent;
    }

    void setLastEvent(EventEnum lastEvent) {
        this.lastEvent = lastEvent;
    }

    public List<Transition> getAvailableTransitions() {
        return this.flow.getAvailableTransitions(this.state);
    }

    protected void awaitTermination() {
        try {
            this.completionLatch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public String toString() {
        return this.id;
    }
}

