/*
 * Decompiled with CFR 0.152.
 */
package au.com.ds.ef;

import au.com.ds.ef.AsyncExecutor;
import au.com.ds.ef.EventEnum;
import au.com.ds.ef.HandlerCollection;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.StatefulContext;
import au.com.ds.ef.Transition;
import au.com.ds.ef.TransitionCollection;
import au.com.ds.ef.call.ContextHandler;
import au.com.ds.ef.call.DefaultErrorHandler;
import au.com.ds.ef.call.EventHandler;
import au.com.ds.ef.call.ExecutionErrorHandler;
import au.com.ds.ef.call.StateHandler;
import au.com.ds.ef.err.ExecutionError;
import au.com.ds.ef.err.LogicViolationError;
import com.google.common.base.Optional;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyFlow<C extends StatefulContext> {
    static Logger log = LoggerFactory.getLogger(EasyFlow.class);
    private StateEnum startState;
    private TransitionCollection transitions;
    private Executor executor;
    private HandlerCollection handlers = new HandlerCollection();
    private boolean trace = false;

    protected EasyFlow(StateEnum startState) {
        this.startState = startState;
        this.handlers.setHandler(HandlerCollection.EventType.ERROR, null, null, new DefaultErrorHandler());
    }

    protected void processAllTransitions(boolean skipValidation) {
        this.transitions = new TransitionCollection(Transition.consumeTransitions(), !skipValidation);
    }

    private void prepare() {
        if (this.executor == null) {
            this.executor = new AsyncExecutor();
        }
    }

    public void start(C context) {
        this.start(false, context);
    }

    public void start(boolean enterInitialState, C context) {
        this.prepare();
        ((StatefulContext)context).setFlow(this);
        if (((StatefulContext)context).getState() == null) {
            this.setCurrentState(this.startState, false, context);
        } else if (enterInitialState) {
            this.setCurrentState(((StatefulContext)context).getState(), true, context);
        }
    }

    protected void setCurrentState(StateEnum state, final boolean enterInitialState, C context) {
        this.execute(new Runnable((StatefulContext)context, state){
            final /* synthetic */ StatefulContext val$context;
            final /* synthetic */ StateEnum val$state;
            {
                this.val$context = statefulContext;
                this.val$state = stateEnum;
            }

            @Override
            public void run() {
                StateEnum prevState;
                if (!enterInitialState && (prevState = this.val$context.getState()) != null) {
                    EasyFlow.this.leave(prevState, this.val$context);
                }
                this.val$context.setState(this.val$state);
                EasyFlow.this.enter(this.val$state, this.val$context);
            }
        });
    }

    protected void execute(Runnable task) {
        this.executor.execute(task);
    }

    public <C1 extends StatefulContext> EasyFlow<C1> whenEvent(EventEnum event, ContextHandler<C1> onEvent) {
        this.handlers.setHandler(HandlerCollection.EventType.EVENT_TRIGGER, null, event, onEvent);
        return this;
    }

    public <C1 extends StatefulContext> EasyFlow<C1> whenEvent(EventHandler<C1> onEvent) {
        this.handlers.setHandler(HandlerCollection.EventType.ANY_EVENT_TRIGGER, null, null, onEvent);
        return this;
    }

    public <C1 extends StatefulContext> EasyFlow<C1> whenEnter(StateEnum state, ContextHandler<C1> onEnter) {
        this.handlers.setHandler(HandlerCollection.EventType.STATE_ENTER, state, null, onEnter);
        return this;
    }

    public <C1 extends StatefulContext> EasyFlow<C1> whenEnter(StateHandler<C1> onEnter) {
        this.handlers.setHandler(HandlerCollection.EventType.ANY_STATE_ENTER, null, null, onEnter);
        return this;
    }

    public <C1 extends StatefulContext> EasyFlow<C1> whenLeave(StateEnum state, ContextHandler<C1> onEnter) {
        this.handlers.setHandler(HandlerCollection.EventType.STATE_LEAVE, state, null, onEnter);
        return this;
    }

    public <C1 extends StatefulContext> EasyFlow<C1> whenLeave(StateHandler<C1> onEnter) {
        this.handlers.setHandler(HandlerCollection.EventType.ANY_STATE_LEAVE, null, null, onEnter);
        return this;
    }

    public <C1 extends StatefulContext> EasyFlow<C1> whenError(ExecutionErrorHandler<C1> onError) {
        this.handlers.setHandler(HandlerCollection.EventType.ERROR, null, null, onError);
        return this;
    }

    public <C1 extends StatefulContext> EasyFlow<C1> whenFinalState(StateHandler<C1> onFinalState) {
        this.handlers.setHandler(HandlerCollection.EventType.FINAL_STATE, null, null, onFinalState);
        return this;
    }

    public void waitForCompletion(C context) {
        ((StatefulContext)context).awaitTermination();
    }

    public <C1 extends StatefulContext> EasyFlow<C1> executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public <C1 extends StatefulContext> EasyFlow<C1> trace() {
        this.trace = true;
        return this;
    }

    public boolean safeTrigger(EventEnum event, C context) {
        try {
            return this.trigger(event, true, context);
        }
        catch (LogicViolationError logicViolationError) {
            return false;
        }
    }

    public void trigger(EventEnum event, C context) throws LogicViolationError {
        this.trigger(event, false, context);
    }

    public List<Transition> getAvailableTransitions(StateEnum stateFrom) {
        return this.transitions.getTransitions(stateFrom);
    }

    private boolean trigger(EventEnum event, boolean safe, C context) throws LogicViolationError {
        if (((StatefulContext)context).isTerminated()) {
            return false;
        }
        StateEnum stateFrom = ((StatefulContext)context).getState();
        Optional<Transition> transition = this.transitions.getTransition(stateFrom, event);
        if (transition.isPresent()) {
            this.execute(new Runnable((Optional)transition, event, stateFrom, (StatefulContext)context){
                final /* synthetic */ Optional val$transition;
                final /* synthetic */ EventEnum val$event;
                final /* synthetic */ StateEnum val$stateFrom;
                final /* synthetic */ StatefulContext val$context;
                {
                    this.val$transition = optional;
                    this.val$event = eventEnum;
                    this.val$stateFrom = stateEnum;
                    this.val$context = statefulContext;
                }

                @Override
                public void run() {
                    try {
                        StateEnum stateTo = ((Transition)this.val$transition.get()).getStateTo();
                        if (EasyFlow.this.isTrace()) {
                            log.debug("when triggered {} in {} for {} <<<", new Object[]{this.val$event, this.val$stateFrom, this.val$context});
                        }
                        EasyFlow.this.handlers.callOnEventTriggered(this.val$event, this.val$stateFrom, stateTo, this.val$context);
                        this.val$context.setLastEvent(this.val$event);
                        if (EasyFlow.this.isTrace()) {
                            log.debug("when triggered {} in {} for {} >>>", new Object[]{this.val$event, this.val$stateFrom, this.val$context});
                        }
                        EasyFlow.this.setCurrentState(stateTo, false, this.val$context);
                    }
                    catch (Exception e) {
                        EasyFlow.this.doOnError(new ExecutionError(this.val$stateFrom, this.val$event, e, "Execution Error in [trigger]", this.val$context));
                    }
                }
            });
        } else if (!safe) {
            throw new LogicViolationError("Invalid Event: " + event + " triggered while in State: " + ((StatefulContext)context).getState() + " for " + context);
        }
        return transition.isPresent();
    }

    private void enter(StateEnum state, C context) {
        if (((StatefulContext)context).isTerminated()) {
            return;
        }
        try {
            if (this.isTrace()) {
                log.debug("when enter {} for {} <<<", (Object)state, context);
            }
            this.handlers.callOnStateEntered(state, context);
            if (this.isTrace()) {
                log.debug("when enter {} for {} >>>", (Object)state, context);
            }
            if (this.transitions.isFinal(state)) {
                this.doOnTerminate(state, context);
            }
        }
        catch (Exception e) {
            this.doOnError(new ExecutionError(state, null, e, "Execution Error in [whenEnter] handler", (StatefulContext)context));
        }
    }

    private void leave(StateEnum state, C context) {
        if (((StatefulContext)context).isTerminated()) {
            return;
        }
        try {
            if (this.isTrace()) {
                log.debug("when leave {} for {} <<<", (Object)state, context);
            }
            this.handlers.callOnStateLeaved(state, context);
            if (this.isTrace()) {
                log.debug("when leave {} for {} >>>", (Object)state, context);
            }
        }
        catch (Exception e) {
            this.doOnError(new ExecutionError(state, null, e, "Execution Error in [whenLeave] handler", (StatefulContext)context));
        }
    }

    protected boolean isTrace() {
        return this.trace;
    }

    protected void doOnError(ExecutionError error) {
        this.handlers.callOnError(error);
        this.doOnTerminate(error.getState(), error.getContext());
    }

    protected StateEnum getStartState() {
        return this.startState;
    }

    protected void doOnTerminate(StateEnum state, C context) {
        if (!((StatefulContext)context).isTerminated()) {
            try {
                if (this.isTrace()) {
                    log.debug("terminating context {}", context);
                }
                ((StatefulContext)context).setTerminated();
                this.handlers.callOnFinalState(state, context);
            }
            catch (Exception e) {
                log.error("Execution Error in [whenTerminate] handler", (Throwable)e);
            }
        }
    }
}

