package au.com.cybersearch2.example;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;


/**
 * Post to some blog with String content.
 */
@Entity(name="tablePost")
public class Post 
{

	/** We use this field-name so we can query for posts with a certain id */
	public final static String ID_FIELD_NAME = "id";

	/** This id is generated by the database and set on the object when it is passed to the create method */
    @Id @GeneratedValue
 	int id;

	/** Contents of the post */
	@Column
	String contents;

    /**
     * Post default constructor for ormlite
     */
	Post() 
	{
	}

	/**
	 * Create Post object
	 * @param contents String
	 */
	public Post(String contents) 
	{
		this.contents = contents;
	}
}
