package au.com.cybersearch2.example;

import au.com.cybersearch2.classyapp.ResourceEnvironment;
import au.com.cybersearch2.classydb.ConnectionSourceFactory;
import au.com.cybersearch2.classydb.DatabaseSupport;
import au.com.cybersearch2.classyjpa.entity.PersistenceContainer;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvideExecutableFactory;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvidePersistenceContainerFactory;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvideTaskMessengerFactory;
import au.com.cybersearch2.classyjpa.persist.PersistenceContext;
import au.com.cybersearch2.classyjpa.persist.PersistenceFactory;
import au.com.cybersearch2.classytask.Executable;
import au.com.cybersearch2.classytask.TaskManager;
import au.com.cybersearch2.classytask.TaskMessenger;
import au.com.cybersearch2.classytask.ThreadHelper;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
  value = "dagger.internal.codegen.ComponentProcessor",
  comments = "https://google.github.io/dagger"
)
public final class DaggerH2ManyToManyFactory_ApplicationComponent
    implements H2ManyToManyFactory.ApplicationComponent {
  private Provider<DatabaseSupport> provideDatabaseSupportProvider;

  private Provider<ResourceEnvironment> provideResourceEnvironmentProvider;

  private Provider<PersistenceFactory> providePersistenceFactoryProvider;

  private Provider<ConnectionSourceFactory> provideConnectionSourceFactoryProvider;

  private Provider<PersistenceContext> providePersistenceContextProvider;

  private Provider<ThreadHelper> provideSystemEnvironmentProvider;

  private Provider<TaskManager> provideTaskManagerProvider;

  private DaggerH2ManyToManyFactory_ApplicationComponent(Builder builder) {
    assert builder != null;
    initialize(builder);
  }

  public static Builder builder() {
    return new Builder();
  }

  @SuppressWarnings("unchecked")
  private void initialize(final Builder builder) {

    this.provideDatabaseSupportProvider =
        DoubleCheck.provider(
            H2ManyToManyModule_ProvideDatabaseSupportFactory.create(builder.h2ManyToManyModule));

    this.provideResourceEnvironmentProvider =
        DoubleCheck.provider(
            H2ManyToManyModule_ProvideResourceEnvironmentFactory.create(
                builder.h2ManyToManyModule));

    this.providePersistenceFactoryProvider =
        DoubleCheck.provider(
            H2ManyToManyModule_ProvidePersistenceFactoryFactory.create(
                builder.h2ManyToManyModule,
                provideDatabaseSupportProvider,
                provideResourceEnvironmentProvider));

    this.provideConnectionSourceFactoryProvider =
        DoubleCheck.provider(
            H2ManyToManyModule_ProvideConnectionSourceFactoryFactory.create(
                builder.h2ManyToManyModule));

    this.providePersistenceContextProvider =
        DoubleCheck.provider(
            H2ManyToManyModule_ProvidePersistenceContextFactory.create(
                builder.h2ManyToManyModule,
                providePersistenceFactoryProvider,
                provideConnectionSourceFactoryProvider));

    this.provideSystemEnvironmentProvider =
        DoubleCheck.provider(
            H2ManyToManyModule_ProvideSystemEnvironmentFactory.create(builder.h2ManyToManyModule));

    this.provideTaskManagerProvider =
        DoubleCheck.provider(
            H2ManyToManyModule_ProvideTaskManagerFactory.create(builder.h2ManyToManyModule));
  }

  @Override
  public PersistenceContext persistenceContext() {
    return providePersistenceContextProvider.get();
  }

  @Override
  public H2ManyToManyFactory.H2PersistenceWorkSubcontext plus(
      PersistenceWorkModule persistenceWorkModule) {
    return new H2PersistenceWorkSubcontextImpl(persistenceWorkModule);
  }

  public static final class Builder {
    private H2ManyToManyModule h2ManyToManyModule;

    private Builder() {}

    public H2ManyToManyFactory.ApplicationComponent build() {
      if (h2ManyToManyModule == null) {
        throw new IllegalStateException(
            H2ManyToManyModule.class.getCanonicalName() + " must be set");
      }
      return new DaggerH2ManyToManyFactory_ApplicationComponent(this);
    }

    public Builder h2ManyToManyModule(H2ManyToManyModule h2ManyToManyModule) {
      this.h2ManyToManyModule = Preconditions.checkNotNull(h2ManyToManyModule);
      return this;
    }
  }

  private final class H2PersistenceWorkSubcontextImpl
      implements H2ManyToManyFactory.H2PersistenceWorkSubcontext {
    private final PersistenceWorkModule persistenceWorkModule;

    private Provider<PersistenceContainer> providePersistenceContainerProvider;

    private Provider<TaskMessenger> provideTaskMessengerProvider;

    private Provider<Executable> provideExecutableProvider;

    private H2PersistenceWorkSubcontextImpl(PersistenceWorkModule persistenceWorkModule) {
      this.persistenceWorkModule = Preconditions.checkNotNull(persistenceWorkModule);
      initialize();
    }

    @SuppressWarnings("unchecked")
    private void initialize() {

      this.providePersistenceContainerProvider =
          DoubleCheck.provider(
              PersistenceWorkModule_ProvidePersistenceContainerFactory.create(
                  persistenceWorkModule,
                  DaggerH2ManyToManyFactory_ApplicationComponent
                      .this
                      .providePersistenceContextProvider));

      this.provideTaskMessengerProvider =
          PersistenceWorkModule_ProvideTaskMessengerFactory.create(persistenceWorkModule);

      this.provideExecutableProvider =
          PersistenceWorkModule_ProvideExecutableFactory.create(
              persistenceWorkModule,
              providePersistenceContainerProvider,
              DaggerH2ManyToManyFactory_ApplicationComponent.this.provideSystemEnvironmentProvider,
              DaggerH2ManyToManyFactory_ApplicationComponent.this.provideTaskManagerProvider,
              provideTaskMessengerProvider);
    }

    @Override
    public Executable executable() {
      return provideExecutableProvider.get();
    }
  }
}
