package au.com.cybersearch2.example;

import au.com.cybersearch2.classyapp.ResourceEnvironment;
import au.com.cybersearch2.classydb.ConnectionSourceFactory;
import au.com.cybersearch2.classydb.DatabaseSupport;
import au.com.cybersearch2.classyjpa.entity.PersistenceContainer;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvideExecutableFactory;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvidePersistenceContainerFactory;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvideTaskMessengerFactory;
import au.com.cybersearch2.classyjpa.persist.PersistenceContext;
import au.com.cybersearch2.classyjpa.persist.PersistenceFactory;
import au.com.cybersearch2.classytask.Executable;
import au.com.cybersearch2.classytask.TaskManager;
import au.com.cybersearch2.classytask.TaskMessenger;
import au.com.cybersearch2.classytask.ThreadHelper;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
  value = "dagger.internal.codegen.ComponentProcessor",
  comments = "https://google.github.io/dagger"
)
public final class DaggerManyToManyFactory_ApplicationComponent
    implements ManyToManyFactory.ApplicationComponent {
  private Provider<DatabaseSupport> provideDatabaseSupportProvider;

  private Provider<ResourceEnvironment> provideResourceEnvironmentProvider;

  private Provider<PersistenceFactory> providePersistenceFactoryProvider;

  private Provider<ConnectionSourceFactory> provideConnectionSourceFactoryProvider;

  private Provider<PersistenceContext> providePersistenceContextProvider;

  private Provider<ThreadHelper> provideSystemEnvironmentProvider;

  private Provider<TaskManager> provideTaskManagerProvider;

  private DaggerManyToManyFactory_ApplicationComponent(Builder builder) {
    assert builder != null;
    initialize(builder);
  }

  public static Builder builder() {
    return new Builder();
  }

  @SuppressWarnings("unchecked")
  private void initialize(final Builder builder) {

    this.provideDatabaseSupportProvider =
        DoubleCheck.provider(
            ManyToManyModule_ProvideDatabaseSupportFactory.create(builder.manyToManyModule));

    this.provideResourceEnvironmentProvider =
        DoubleCheck.provider(
            ManyToManyModule_ProvideResourceEnvironmentFactory.create(builder.manyToManyModule));

    this.providePersistenceFactoryProvider =
        DoubleCheck.provider(
            ManyToManyModule_ProvidePersistenceFactoryFactory.create(
                builder.manyToManyModule,
                provideDatabaseSupportProvider,
                provideResourceEnvironmentProvider));

    this.provideConnectionSourceFactoryProvider =
        DoubleCheck.provider(
            ManyToManyModule_ProvideConnectionSourceFactoryFactory.create(
                builder.manyToManyModule));

    this.providePersistenceContextProvider =
        DoubleCheck.provider(
            ManyToManyModule_ProvidePersistenceContextFactory.create(
                builder.manyToManyModule,
                providePersistenceFactoryProvider,
                provideConnectionSourceFactoryProvider));

    this.provideSystemEnvironmentProvider =
        DoubleCheck.provider(
            ManyToManyModule_ProvideSystemEnvironmentFactory.create(builder.manyToManyModule));

    this.provideTaskManagerProvider =
        DoubleCheck.provider(
            ManyToManyModule_ProvideTaskManagerFactory.create(builder.manyToManyModule));
  }

  @Override
  public PersistenceContext persistenceContext() {
    return providePersistenceContextProvider.get();
  }

  @Override
  public ManyToManyFactory.PersistenceWorkSubcontext plus(
      PersistenceWorkModule persistenceWorkModule) {
    return new PersistenceWorkSubcontextImpl(persistenceWorkModule);
  }

  public static final class Builder {
    private ManyToManyModule manyToManyModule;

    private Builder() {}

    public ManyToManyFactory.ApplicationComponent build() {
      if (manyToManyModule == null) {
        throw new IllegalStateException(ManyToManyModule.class.getCanonicalName() + " must be set");
      }
      return new DaggerManyToManyFactory_ApplicationComponent(this);
    }

    public Builder manyToManyModule(ManyToManyModule manyToManyModule) {
      this.manyToManyModule = Preconditions.checkNotNull(manyToManyModule);
      return this;
    }
  }

  private final class PersistenceWorkSubcontextImpl
      implements ManyToManyFactory.PersistenceWorkSubcontext {
    private final PersistenceWorkModule persistenceWorkModule;

    private Provider<PersistenceContainer> providePersistenceContainerProvider;

    private Provider<TaskMessenger> provideTaskMessengerProvider;

    private Provider<Executable> provideExecutableProvider;

    private PersistenceWorkSubcontextImpl(PersistenceWorkModule persistenceWorkModule) {
      this.persistenceWorkModule = Preconditions.checkNotNull(persistenceWorkModule);
      initialize();
    }

    @SuppressWarnings("unchecked")
    private void initialize() {

      this.providePersistenceContainerProvider =
          DoubleCheck.provider(
              PersistenceWorkModule_ProvidePersistenceContainerFactory.create(
                  persistenceWorkModule,
                  DaggerManyToManyFactory_ApplicationComponent
                      .this
                      .providePersistenceContextProvider));

      this.provideTaskMessengerProvider =
          PersistenceWorkModule_ProvideTaskMessengerFactory.create(persistenceWorkModule);

      this.provideExecutableProvider =
          PersistenceWorkModule_ProvideExecutableFactory.create(
              persistenceWorkModule,
              providePersistenceContainerProvider,
              DaggerManyToManyFactory_ApplicationComponent.this.provideSystemEnvironmentProvider,
              DaggerManyToManyFactory_ApplicationComponent.this.provideTaskManagerProvider,
              provideTaskMessengerProvider);
    }

    @Override
    public Executable executable() {
      return provideExecutableProvider.get();
    }
  }
}
