/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.example;

import au.com.cybersearch2.classyjpa.EntityManagerLite;
import au.com.cybersearch2.classyjpa.entity.PersistenceWork;
import au.com.cybersearch2.example.Post;
import au.com.cybersearch2.example.User;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class UsersByPostTask
implements PersistenceWork {
    User user1 = new User();
    User user2;
    Post post1;
    Post post2;
    List<List<User>> resultsList;

    public UsersByPostTask(int user1_id, int user2_id, int post1_id, int post2_id) {
        this.user1.id = user1_id;
        this.user2 = new User();
        this.user2.id = user2_id;
        this.post1 = new Post();
        this.post1.id = post1_id;
        this.post2 = new Post();
        this.post2.id = post2_id;
        this.resultsList = new ArrayList<List<User>>(2);
    }

    public List<User> getUsersByPost1() {
        return this.resultsList.size() == 2 ? this.resultsList.get(0) : new ArrayList<User>();
    }

    public List<User> getUsersByPost2() {
        return this.resultsList.size() == 2 ? this.resultsList.get(1) : new ArrayList<User>();
    }

    public void doTask(EntityManagerLite entityManager) {
        entityManager.merge((Object)this.user1);
        entityManager.merge((Object)this.user2);
        entityManager.merge((Object)this.post1);
        entityManager.merge((Object)this.post2);
        entityManager.refresh((Object)this.user1);
        entityManager.refresh((Object)this.user2);
        entityManager.refresh((Object)this.post1);
        entityManager.refresh((Object)this.post2);
        Query query = entityManager.createNamedQuery("users_by_post");
        query.setParameter("post_id", (Object)this.post1.id);
        this.resultsList.add(query.getResultList());
        query = entityManager.createNamedQuery("users_by_post");
        query.setParameter("post_id", (Object)this.post2.id);
        this.resultsList.add(query.getResultList());
    }

    public void onPostExecute(boolean success) {
        if (!success) {
            throw new IllegalStateException("Query users_by_post failed. Check console for error details.");
        }
    }

    public void onRollback(Throwable rollbackException) {
        throw new IllegalStateException("Query users_by_post failed. Check console for stack trace.", rollbackException);
    }
}

