/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.example;

import au.com.cybersearch2.classyapp.ResourceEnvironment;
import au.com.cybersearch2.classydb.ConnectionSourceFactory;
import au.com.cybersearch2.classydb.DatabaseSupport;
import au.com.cybersearch2.classydb.SQLiteDatabaseSupport;
import au.com.cybersearch2.classyjpa.persist.PersistenceContext;
import au.com.cybersearch2.classyjpa.persist.PersistenceFactory;
import au.com.cybersearch2.classytask.TaskManager;
import au.com.cybersearch2.classytask.TestSystemEnvironment;
import au.com.cybersearch2.classytask.ThreadHelper;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;

@Module
public class ManyToManyModule {
    private ResourceEnvironment resourceEnvironment;
    private SQLiteDatabaseSupport sqliteDatabaseSupport;

    public ManyToManyModule(ResourceEnvironment resourceEnvironment) {
        this.resourceEnvironment = resourceEnvironment;
    }

    @Provides
    @Singleton
    ThreadHelper provideSystemEnvironment() {
        return new TestSystemEnvironment();
    }

    @Provides
    @Singleton
    TaskManager provideTaskManager() {
        return new TaskManager();
    }

    @Provides
    @Singleton
    ResourceEnvironment provideResourceEnvironment() {
        return this.resourceEnvironment;
    }

    @Provides
    @Singleton
    DatabaseSupport provideDatabaseSupport() {
        this.sqliteDatabaseSupport = new SQLiteDatabaseSupport(DatabaseSupport.ConnectionType.memory);
        return this.sqliteDatabaseSupport;
    }

    @Provides
    @Singleton
    PersistenceFactory providePersistenceFactory(DatabaseSupport databaseSupport, ResourceEnvironment resourceEnvironment) {
        return new PersistenceFactory(databaseSupport, resourceEnvironment);
    }

    @Provides
    @Singleton
    ConnectionSourceFactory provideConnectionSourceFactory() {
        return this.sqliteDatabaseSupport;
    }

    @Provides
    @Singleton
    PersistenceContext providePersistenceContext(PersistenceFactory persistenceFactory, ConnectionSourceFactory connectionSourceFactory) {
        return new PersistenceContext(persistenceFactory, connectionSourceFactory);
    }
}

