/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.example;

import au.com.cybersearch2.classyjpa.EntityManagerLite;
import au.com.cybersearch2.classyjpa.entity.PersistenceWork;
import au.com.cybersearch2.classyjpa.persist.PersistenceAdmin;
import au.com.cybersearch2.classyjpa.persist.PersistenceContext;
import au.com.cybersearch2.classyjpa.query.DaoQueryFactory;
import au.com.cybersearch2.classytask.WorkStatus;
import au.com.cybersearch2.example.ManyToManyFactory;
import au.com.cybersearch2.example.ManyToManyGenerator;
import au.com.cybersearch2.example.Post;
import au.com.cybersearch2.example.PostsByUserEntityTask;
import au.com.cybersearch2.example.User;
import au.com.cybersearch2.example.UserPost;
import au.com.cybersearch2.example.UsersByPostTask;
import java.util.List;
import org.junit.Assert;

public class ManyToManyMain {
    public static final String POSTS_BY_USER = "posts_by_user";
    public static final String USERS_BY_POST = "users_by_post";
    public static final String PU_NAME = "manytomany";
    User user1;
    User user2;
    Post post1;
    Post post2;
    protected PersistenceContext persistenceContext = this.createFactory();
    protected ManyToManyFactory manyToManyFactory;

    public ManyToManyMain() {
        PersistenceAdmin persistenceAdmin = this.persistenceContext.getPersistenceAdmin(PU_NAME);
        ManyToManyGenerator manyToManyPostsByUser = new ManyToManyGenerator(persistenceAdmin, "tableUserPost", "user_id", "post_id", "id");
        ManyToManyGenerator manyToManyUsersByPost = new ManyToManyGenerator(persistenceAdmin, "tableUserPost", "post_id", "user_id", "id");
        persistenceAdmin.addNamedQuery(Post.class, POSTS_BY_USER, (DaoQueryFactory)manyToManyPostsByUser);
        persistenceAdmin.addNamedQuery(User.class, USERS_BY_POST, (DaoQueryFactory)manyToManyUsersByPost);
    }

    public static void main(String[] args) {
        new ManyToManyMain().runApplication();
    }

    public void setUp() throws InterruptedException {
        PersistenceWork setUpWork = new PersistenceWork(){

            public void doTask(EntityManagerLite entityManager) {
                ManyToManyMain.this.user1 = new User("Bilbo Baggins");
                entityManager.persist((Object)ManyToManyMain.this.user1);
                ManyToManyMain.this.post1 = new Post("Wow is it cold outside!!");
                entityManager.persist((Object)ManyToManyMain.this.post1);
                UserPost user1Post1 = new UserPost(ManyToManyMain.this.user1, ManyToManyMain.this.post1);
                entityManager.persist((Object)user1Post1);
                ManyToManyMain.this.post2 = new Post("Now it's a bit warmer thank goodness.");
                entityManager.persist((Object)ManyToManyMain.this.post2);
                UserPost user1Post2 = new UserPost(ManyToManyMain.this.user1, ManyToManyMain.this.post2);
                entityManager.persist((Object)user1Post2);
                ManyToManyMain.this.user2 = new User("Gandalf Gray");
                entityManager.persist((Object)ManyToManyMain.this.user2);
                UserPost user2Post1 = new UserPost(ManyToManyMain.this.user2, ManyToManyMain.this.post2);
                entityManager.persist((Object)user2Post1);
            }

            public void onPostExecute(boolean success) {
                if (!success) {
                    throw new IllegalStateException("Database set up failed. Check console for error details.");
                }
            }

            public void onRollback(Throwable rollbackException) {
                throw new IllegalStateException("Database set up failed. Check console for stack trace.", rollbackException);
            }
        };
        this.execute(setUpWork);
    }

    protected PersistenceContext createFactory() {
        this.manyToManyFactory = new ManyToManyFactory();
        return this.manyToManyFactory.getPersistenceContext();
    }

    protected WorkStatus execute(PersistenceWork persistenceWork) throws InterruptedException {
        return this.manyToManyFactory.getExecutable(persistenceWork).waitForTask();
    }

    public void close() {
        this.persistenceContext.close();
    }

    public User getUser1() {
        return this.user1;
    }

    public User getUser2() {
        return this.user2;
    }

    public Post getPost1() {
        return this.post1;
    }

    public Post getPost2() {
        return this.post2;
    }

    public void verifyPostsByUser(List<Post> posts) {
        Assert.assertEquals((long)2L, (long)posts.size());
        Assert.assertEquals((long)this.post1.id, (long)posts.get((int)0).id);
        Assert.assertEquals((Object)this.post1.contents, (Object)posts.get((int)0).contents);
        Assert.assertEquals((long)this.post2.id, (long)posts.get((int)1).id);
        Assert.assertEquals((Object)this.post2.contents, (Object)posts.get((int)1).contents);
    }

    public void verifyUsersByPost(List<User> usersByPost1, List<User> usersByPost2) {
        Assert.assertEquals((long)1L, (long)usersByPost1.size());
        Assert.assertEquals((long)this.user1.id, (long)usersByPost1.get((int)0).id);
        Assert.assertEquals((long)2L, (long)usersByPost2.size());
        Assert.assertEquals((long)this.user1.id, (long)usersByPost2.get((int)0).id);
        Assert.assertEquals((Object)this.user1.name, (Object)usersByPost2.get((int)0).name);
        Assert.assertEquals((long)this.user2.id, (long)usersByPost2.get((int)1).id);
        Assert.assertEquals((Object)this.user2.name, (Object)usersByPost2.get((int)1).name);
    }

    protected void runApplication() {
        try {
            this.setUp();
            User user1 = this.getUser1();
            User user2 = this.getUser2();
            Post post1 = this.getPost1();
            Post post2 = this.getPost2();
            PostsByUserEntityTask postsByUserEntityTask = new PostsByUserEntityTask(user1.id, user2.id, post1.id, post2.id);
            this.execute(postsByUserEntityTask);
            List<Post> posts = postsByUserEntityTask.getPosts();
            this.verifyPostsByUser(posts);
            System.out.println("PostsByUser: ");
            System.out.println(user1.name + " posted \"" + posts.get((int)0).contents + "\" & \"" + posts.get((int)1).contents + "\"");
            UsersByPostTask usersByPostTask = new UsersByPostTask(user1.id, user2.id, post1.id, post2.id);
            this.execute(usersByPostTask);
            this.verifyUsersByPost(usersByPostTask.getUsersByPost1(), usersByPostTask.getUsersByPost2());
            System.out.println("UsersByPosts: ");
            System.out.println("Only " + user1.name + " posted \"" + post1.contents + "\"");
            System.out.println("Both " + user1.name + " and " + user2.name + " posted \"" + post2.contents + "\"");
            System.out.println("Test completed successfully");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

