/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.example;

import au.com.cybersearch2.classyjpa.entity.PersistenceDao;
import au.com.cybersearch2.classyjpa.persist.PersistenceAdmin;
import au.com.cybersearch2.classyjpa.query.DaoQuery;
import au.com.cybersearch2.classyjpa.query.DaoQueryFactory;
import au.com.cybersearch2.classyjpa.query.QueryInfo;
import au.com.cybersearch2.classyjpa.query.ResultRow;
import au.com.cybersearch2.classyjpa.query.SqlQuery;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.PersistenceException;

public class ManyToManyGenerator
implements DaoQueryFactory {
    String table;
    String joinColumn;
    String foreignKeyColumn;
    String primaryKeyColumn;
    PersistenceAdmin persistenceAdmin;

    public ManyToManyGenerator(PersistenceAdmin persistenceAdmin, String table, String joinColumn, String foreignKeyColumn, String primaryKeyColumn) {
        this.persistenceAdmin = persistenceAdmin;
        this.table = table;
        this.joinColumn = joinColumn;
        this.foreignKeyColumn = foreignKeyColumn;
        this.primaryKeyColumn = primaryKeyColumn;
    }

    public <T> DaoQuery<T> generateQuery(PersistenceDao<T, ?> dao) throws SQLException {
        DaoQuery.SimpleSelectArg primaryKeyArg = new DaoQuery.SimpleSelectArg();
        DaoQuery.SimpleSelectArg[] selectionArguments = new DaoQuery.SimpleSelectArg[]{primaryKeyArg};
        primaryKeyArg.setMetaInfo(this.joinColumn);
        return new ManyToManyQuery<T>(dao, selectionArguments);
    }

    class ManyToManyQuery<T>
    extends DaoQuery<T> {
        protected PreparedQuery<T> preparedStatement;
        protected DaoQuery.SimpleSelectArg primaryKeyArg;

        public ManyToManyQuery(PersistenceDao<T, ?> dao, DaoQuery.SimpleSelectArg ... primaryKey) throws SQLException {
            super(dao, primaryKey);
            this.primaryKeyArg = primaryKey[0];
        }

        protected QueryBuilder<T, ?> buildQuery(QueryBuilder<T, ?> statementBuilder) throws SQLException {
            Object value = this.primaryKeyArg.getValue();
            if (value == null || !(value instanceof Integer)) {
                throw new PersistenceException("Invalid value for param " + ManyToManyGenerator.this.joinColumn + ": " + value);
            }
            int id = (Integer)value;
            statementBuilder.where().in(ManyToManyGenerator.this.primaryKeyColumn, this.getPrimaryKeyList(id));
            return statementBuilder;
        }

        List<Integer> getPrimaryKeyList(int joinId) {
            QueryInfo queryInfo = new QueryInfo(new QueryInfo.RowMapper(){

                public Object mapRow(ResultRow resultRow) {
                    return resultRow.getInt(0);
                }
            }, ManyToManyGenerator.this.table, new String[]{ManyToManyGenerator.this.foreignKeyColumn});
            queryInfo.setParameterNames(new String[]{ManyToManyGenerator.this.joinColumn});
            queryInfo.setSelection(ManyToManyGenerator.this.joinColumn + " = ?");
            SqlQuery sqlQuery = new SqlQuery(ManyToManyGenerator.this.persistenceAdmin, queryInfo);
            sqlQuery.setParam(ManyToManyGenerator.this.joinColumn, (Object)joinId);
            return sqlQuery.getResultObjectList();
        }
    }
}

