package au.com.cybersearch2.example;

import au.com.cybersearch2.classyapp.ResourceEnvironment;
import au.com.cybersearch2.classydb.ConnectionSourceFactory;
import au.com.cybersearch2.classydb.DatabaseSupport;
import au.com.cybersearch2.classyjpa.entity.PersistenceContainer;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvideExecutableFactory;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvidePersistenceContainerFactory;
import au.com.cybersearch2.classyjpa.entity.PersistenceWorkModule_ProvideTaskMessengerFactory;
import au.com.cybersearch2.classyjpa.persist.PersistenceContext;
import au.com.cybersearch2.classyjpa.persist.PersistenceFactory;
import au.com.cybersearch2.classytask.Executable;
import au.com.cybersearch2.classytask.TaskManager;
import au.com.cybersearch2.classytask.TaskMessenger;
import au.com.cybersearch2.classytask.ThreadHelper;
import au.com.cybersearch2.example.ManyToManyFactory.ApplicationComponent;
import au.com.cybersearch2.example.ManyToManyFactory.PersistenceWorkSubcontext;
import dagger.internal.ScopedProvider;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated("dagger.internal.codegen.ComponentProcessor")
public final class DaggerManyToManyFactory_ApplicationComponent implements ApplicationComponent {
  private Provider<DatabaseSupport> provideDatabaseSupportProvider;
  private Provider<ResourceEnvironment> provideResourceEnvironmentProvider;
  private Provider<PersistenceFactory> providePersistenceFactoryProvider;
  private Provider<ConnectionSourceFactory> provideConnectionSourceFactoryProvider;
  private Provider<PersistenceContext> providePersistenceContextProvider;
  private Provider<ThreadHelper> provideSystemEnvironmentProvider;
  private Provider<TaskManager> provideTaskManagerProvider;

  private DaggerManyToManyFactory_ApplicationComponent(Builder builder) {  
    assert builder != null;
    initialize(builder);
  }

  public static Builder builder() {  
    return new Builder();
  }

  private void initialize(final Builder builder) {  
    this.provideDatabaseSupportProvider = ScopedProvider.create(ManyToManyModule_ProvideDatabaseSupportFactory.create(builder.manyToManyModule));
    this.provideResourceEnvironmentProvider = ScopedProvider.create(ManyToManyModule_ProvideResourceEnvironmentFactory.create(builder.manyToManyModule));
    this.providePersistenceFactoryProvider = ScopedProvider.create(ManyToManyModule_ProvidePersistenceFactoryFactory.create(builder.manyToManyModule, provideDatabaseSupportProvider, provideResourceEnvironmentProvider));
    this.provideConnectionSourceFactoryProvider = ScopedProvider.create(ManyToManyModule_ProvideConnectionSourceFactoryFactory.create(builder.manyToManyModule));
    this.providePersistenceContextProvider = ScopedProvider.create(ManyToManyModule_ProvidePersistenceContextFactory.create(builder.manyToManyModule, providePersistenceFactoryProvider, provideConnectionSourceFactoryProvider));
    this.provideSystemEnvironmentProvider = ScopedProvider.create(ManyToManyModule_ProvideSystemEnvironmentFactory.create(builder.manyToManyModule));
    this.provideTaskManagerProvider = ScopedProvider.create(ManyToManyModule_ProvideTaskManagerFactory.create(builder.manyToManyModule));
  }

  @Override
  public PersistenceContext persistenceContext() {  
    return providePersistenceContextProvider.get();
  }

  @Override
  public PersistenceWorkSubcontext plus(PersistenceWorkModule persistenceWorkModule) {  
    return new PersistenceWorkSubcontextImpl(persistenceWorkModule);
  }

  public static final class Builder {
    private ManyToManyModule manyToManyModule;
  
    private Builder() {  
    }
  
    public ApplicationComponent build() {  
      if (manyToManyModule == null) {
        throw new IllegalStateException("manyToManyModule must be set");
      }
      return new DaggerManyToManyFactory_ApplicationComponent(this);
    }
  
    public Builder manyToManyModule(ManyToManyModule manyToManyModule) {  
      if (manyToManyModule == null) {
        throw new NullPointerException("manyToManyModule");
      }
      this.manyToManyModule = manyToManyModule;
      return this;
    }
  }

  private final class PersistenceWorkSubcontextImpl implements PersistenceWorkSubcontext {
    private final PersistenceWorkModule persistenceWorkModule;
    private Provider<PersistenceContainer> providePersistenceContainerProvider;
    private Provider<TaskMessenger> provideTaskMessengerProvider;
    private Provider<Executable> provideExecutableProvider;
  
    private PersistenceWorkSubcontextImpl(PersistenceWorkModule persistenceWorkModule) {  
      if (persistenceWorkModule == null) {
        throw new NullPointerException();
      }
      this.persistenceWorkModule = persistenceWorkModule;
      initialize();
    }
  
    private void initialize() {  
      this.providePersistenceContainerProvider = ScopedProvider.create(PersistenceWorkModule_ProvidePersistenceContainerFactory.create(persistenceWorkModule, DaggerManyToManyFactory_ApplicationComponent.this.providePersistenceContextProvider));
      this.provideTaskMessengerProvider = PersistenceWorkModule_ProvideTaskMessengerFactory.create(persistenceWorkModule);
      this.provideExecutableProvider = PersistenceWorkModule_ProvideExecutableFactory.create(persistenceWorkModule, providePersistenceContainerProvider, DaggerManyToManyFactory_ApplicationComponent.this.provideSystemEnvironmentProvider, DaggerManyToManyFactory_ApplicationComponent.this.provideTaskManagerProvider, provideTaskMessengerProvider);
    }
  
    @Override
    public Executable executable() {  
      return provideExecutableProvider.get();
    }
  }
}

