package au.com.cybersearch2.example;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

/**
 * Join table which links users to their posts.
 * 
 * <p>
 * For more information about foreign objects, see the <a href="http://ormlite.com/docs/foreign" >online docs</a>
 * </p>
 */
@Entity(name="tableUserPost")
public class UserPost 
{
    /** Column name in join table for user foreign key */
	public final static String USER_ID_FIELD_NAME = "user_id";
    /** Column name in join table for post foreign key */
	public final static String POST_ID_FIELD_NAME = "post_id";

	/**
	 * This id is generated by the database and set on the object when it is passed to the create method. An id is
	 * needed in case we need to update or delete this object in the future.
	 */
    @Id @GeneratedValue
	int id;

	/** This is a foreign object which just stores the id from the User object in this table. */
    @OneToOne
    @JoinColumn(name=USER_ID_FIELD_NAME, referencedColumnName="id")
	User user;

	/** This is a foreign object which just stores the id from the Post object in this table. */
    @OneToOne
    @JoinColumn(name=POST_ID_FIELD_NAME, referencedColumnName="id")
	Post post;

    /**
     * UserPost default constructor for ormlite
     */
	UserPost() 
	{
	}

	/**
	 * Create UserPost object
	 * @param user User
	 * @param post Post
	 */
	public UserPost(User user, Post post) 
	{
		this.user = user;
		this.post = post;
	}
}
