package au.com.cybersearch2.example;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;


/**
 * Another demonstration object we are creating and persisting to the database.
 */
@Entity(name="Complex")
public class ComplexData 
{
	/** This id is generated by the database and set on the object when it is passed to the create method */
    @Id @GeneratedValue
	int id;

	@Column
	long secs;

	@Column
	boolean odd;

	ComplexData() 
	{
		// needed by ormlite
	}

	public ComplexData(long millis) 
	{
		this.secs = millis / 1000;
		this.odd = ((this.getSecs() % 2) == 1);
	}

	public long getSecs() 
	{
		return secs;
	}

	@Override
	public String toString() 
	{
		StringBuilder sb = new StringBuilder();
		sb.append("id=").append(id);
		sb.append(", ").append("secs=").append(getSecs());
		sb.append(", ").append("odd=").append(odd);
		return sb.toString();
	}
}
