/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.classytask;

import au.com.cybersearch2.classytask.ThreadHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BackgroundTask
implements Callable<Boolean> {
    protected ExecutionException executionException;
    private final AtomicBoolean taskInvoked = new AtomicBoolean();
    private ThreadHelper threadHelper;

    public BackgroundTask(ThreadHelper threadHelper) {
        this.threadHelper = threadHelper;
    }

    public abstract boolean doInBackground();

    public void onPreExecute() {
    }

    public void onPostExecute(Boolean result) {
    }

    public void onCancelled(Boolean result) {
    }

    @Override
    public Boolean call() throws Exception {
        this.taskInvoked.set(true);
        this.threadHelper.setBackgroundPriority();
        return this.doInBackground();
    }

    public void setExecutionException(ExecutionException executionException) {
        this.executionException = executionException;
    }

    public ExecutionException getExecutionException() {
        return this.executionException;
    }

    protected boolean wasTaskInvoked() {
        boolean wasTaskInvoked = this.taskInvoked.get();
        return wasTaskInvoked;
    }
}

