/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.classybean;

import au.com.cybersearch2.classybean.BeanUtil;
import com.googlecode.openbeans.BeanInfo;
import com.googlecode.openbeans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BeanMap
extends AbstractMap<String, Object> {
    private HashMap<String, PropertyDescriptor> properties;
    private Object bean;

    public BeanMap(Object bean) {
        this.bean = bean;
        this.properties = new HashMap();
        BeanInfo info = BeanUtil.getBeanInfo(bean);
        for (PropertyDescriptor property : info.getPropertyDescriptors()) {
            this.properties.put(property.getName(), property);
        }
    }

    @Override
    public Object get(Object key) {
        PropertyDescriptor property = this.properties.get(key);
        return property == null ? null : this.invoke(property);
    }

    @Override
    public Object put(String key, Object value) {
        PropertyDescriptor property = this.properties.get(key);
        Method method = property.getWriteMethod();
        return BeanUtil.invoke(method, this.bean, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<PropertyEntry> result = new HashSet<PropertyEntry>(this.properties.size() * 2);
        for (PropertyDescriptor property : this.properties.values()) {
            String key = property.getName();
            Object value = null;
            value = this.invoke(property);
            result.add(new PropertyEntry(key, value));
        }
        return Collections.unmodifiableSet(result);
    }

    protected Object invoke(PropertyDescriptor property) {
        Method method = property.getReadMethod();
        if (method == null) {
            return null;
        }
        return BeanUtil.invoke(method, this.bean, BeanUtil.NO_ARGS);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    class PropertyEntry
    extends AbstractMap.SimpleEntry<String, Object> {
        private static final long serialVersionUID = -6784633780309646695L;

        PropertyEntry(String key, Object value) {
            super(key, value);
        }

        @Override
        public Object setValue(Object value) {
            super.setValue(value);
            return BeanMap.this.put((String)this.getKey(), value);
        }
    }
}

