/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.classybean;

import au.com.cybersearch2.classybean.BeanException;
import au.com.cybersearch2.classybean.BeanUtil;
import au.com.cybersearch2.classyfy.data.alfresco.RecordCategory;
import dagger.Module;
import dagger.Provides;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.fest.assertions.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class BeanUtilTest {
    Date created;
    Date modified;

    @Before
    public void setUp() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS", new Locale("en", "AU"));
        this.created = sdf.parse("2014-02-05 18:45:46.000000");
        this.modified = sdf.parse("2014-02-12 11:55:23.000000");
    }

    @Test
    public void test_BeanMap() throws Exception {
        RecordCategory recordCategory = new RecordCategory();
        this.populateRecordCategory(recordCategory);
        Set datapairSet = BeanUtil.getDataPairSet((Object)recordCategory);
        int size = datapairSet.size();
        Assertions.assertThat((int)size).isGreaterThan(6);
        HashMap<Object, Object> shadowMap = new HashMap<Object, Object>();
        for (BeanUtil.DataPair entry : datapairSet) {
            shadowMap.put(entry.getKey(), entry.getValue());
        }
        Assertions.assertThat((boolean)shadowMap.containsKey("created")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("modified")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("creator")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("modifier")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("description")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("identifier")).isTrue();
        Assertions.assertThat(shadowMap.get("created")).isEqualTo((Object)this.created);
        Assertions.assertThat(shadowMap.get("modified")).isEqualTo((Object)this.modified);
        Assertions.assertThat(shadowMap.get("creator")).isEqualTo((Object)"admin");
        Assertions.assertThat(shadowMap.get("modifier")).isEqualTo((Object)"prole");
        Assertions.assertThat(shadowMap.get("description")).isEqualTo((Object)"Information Technology");
        Assertions.assertThat(shadowMap.get("identifier")).isEqualTo((Object)"2014-1391586274589");
    }

    @Test
    public void test_newClassInstance() {
        Object module = BeanUtil.newClassInstance((String)TestModule2.class.getName());
        Assertions.assertThat((Object)module).isNotNull();
        String badClassName = TestModule2.class.getName() + "X";
        try {
            BeanUtil.newClassInstance((String)badClassName);
            Assertions.failBecauseExceptionWasNotThrown(BeanException.class);
        }
        catch (BeanException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)("Class " + badClassName + " not found"));
        }
    }

    @Test
    public void test_newClassInstance_null_classname() {
        try {
            BeanUtil.newClassInstance(null);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Parameter className is null");
        }
    }

    protected void populateRecordCategory(RecordCategory recordCategory) {
        recordCategory.setCreated(this.created);
        recordCategory.setModified(this.modified);
        recordCategory.setCreator("admin");
        recordCategory.setModifier("prole");
        recordCategory.setDescription("Information Technology");
        recordCategory.setIdentifier("2014-1391586274589");
    }

    static class Injectee {
        @Inject
        Object object;

        Injectee() {
        }

        Object get() {
            return this.object;
        }
    }

    @Module
    static class TestModule2 {
        TestModule2() {
        }

        @Provides
        Object provideObject() {
            return new Object();
        }
    }
}

