/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.classytask;

import au.com.cybersearch2.classylog.JavaLogger;
import au.com.cybersearch2.classylog.Log;
import au.com.cybersearch2.classytask.Executable;
import au.com.cybersearch2.classytask.WorkStatus;
import java.util.logging.Level;

public class WorkTracker
extends Executable {
    private static final String TAG = "WorkTracker";
    private static Log log = JavaLogger.getLogger("WorkTracker");
    public static final int MAX_TASK_WAIT_SECS = 60;
    protected volatile WorkStatus workStatus = WorkStatus.PENDING;
    protected String taskName;

    public WorkTracker() {
        this.taskName = Thread.currentThread().getName();
    }

    public WorkTracker(String taskName) {
        this.taskName = taskName;
    }

    @Override
    public WorkStatus getStatus() {
        return this.workStatus;
    }

    public void setStatus(WorkStatus status) {
        this.workStatus = status;
    }

    public WorkStatus waitForTask(WorkTracker workTracker) {
        return this.waitForTask(workTracker, 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkStatus waitForTask(WorkTracker workTracker, int timeoutSecs) {
        if (timeoutSecs < 0) {
            timeoutSecs = 60;
        }
        WorkStatus workStatus = WorkStatus.PENDING;
        if (workTracker.getStatus() == WorkStatus.RUNNING) {
            if (timeoutSecs == 0 && !log.isLoggable(TAG, Level.FINE)) {
                timeoutSecs = 60;
            }
            if (timeoutSecs == 0) {
                WorkTracker workTracker2 = workTracker;
                synchronized (workTracker2) {
                    try {
                        workTracker.wait();
                    }
                    catch (InterruptedException e) {
                        log.warn(TAG, this.taskName + " interrupted", e);
                    }
                }
            }
            this.waitTicks(workTracker, timeoutSecs);
            workStatus = workTracker.getStatus();
        }
        return workStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTicks(Executable task, int timeoutSecs) {
        int tick;
        for (tick = 0; tick < timeoutSecs; ++tick) {
            Executable executable = task;
            synchronized (executable) {
                try {
                    task.wait(1000L);
                }
                catch (InterruptedException e) {
                    log.warn(TAG, "createDatabaseTask interrupted", e);
                    return;
                }
            }
            if (task.getStatus() != WorkStatus.RUNNING) break;
        }
        if (tick == 60) {
            log.warn(TAG, "Task \"" + this.taskName + "\" taking more than " + 60 + " seconds to complete");
        }
    }
}

