/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.classytask;

import au.com.cybersearch2.classytask.BackgroundTask;
import au.com.cybersearch2.classytask.Executable;
import au.com.cybersearch2.classytask.TaskManager;
import au.com.cybersearch2.classytask.TaskMessenger;
import au.com.cybersearch2.classytask.WorkStatus;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class TaskRunner
extends Executable {
    protected TaskManager taskManager;
    TaskMessenger taskMessenger;
    protected volatile WorkStatus status;
    protected BackgroundTask backgroundTask;
    private FutureTask<Boolean> future;

    public TaskRunner(TaskManager taskManager, TaskMessenger taskMessenger) {
        this.taskManager = taskManager;
        this.taskMessenger = taskMessenger;
        this.status = WorkStatus.PENDING;
    }

    @Override
    public WorkStatus getStatus() {
        return this.status;
    }

    public final Executable execute(BackgroundTask backgroundTask) {
        switch (this.status) {
            case RUNNING: {
                throw new IllegalStateException("Cannot execute task: the task is already running.");
            }
            case FINISHED: 
            case FAILED: {
                throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
            }
            case PENDING: {
                break;
            }
        }
        this.status = WorkStatus.RUNNING;
        this.backgroundTask = backgroundTask;
        backgroundTask.onPreExecute();
        this.future = this.createFutureTask();
        this.taskManager.getExecutor().execute(this.future);
        return this;
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public final boolean isCancelled() {
        return this.future == null || this.future.isCancelled();
    }

    protected Boolean postResult(Boolean result) {
        if (this.future == null || this.future.isCancelled()) {
            this.taskMessenger.sendCancel(this.backgroundTask, result);
        } else {
            this.taskMessenger.sendResult(this, result);
        }
        return result;
    }

    protected void finish(Boolean result) {
        if (this.future == null || this.future.isCancelled()) {
            this.backgroundTask.onCancelled(result);
        } else {
            this.backgroundTask.onPostExecute(result);
        }
        if (this.status != WorkStatus.FAILED) {
            this.status = WorkStatus.FINISHED;
        }
    }

    private FutureTask<Boolean> createFutureTask() {
        return new FutureTask<Boolean>((Callable)this.backgroundTask){

            @Override
            protected void done() {
                Boolean result = null;
                try {
                    result = (Boolean)this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    TaskRunner.this.backgroundTask.setExecutionException(e);
                    TaskRunner.this.postResult(null);
                    throw new RuntimeException("An error occured while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                }
                catch (Throwable t) {
                    throw new RuntimeException("An error occured while executing doInBackground()", t);
                }
                if (TaskRunner.this.backgroundTask.wasTaskInvoked()) {
                    TaskRunner.this.postResult(result);
                }
            }
        };
    }
}

